/*
 * Decompiled with CFR 0.152.
 */
package org.bigtesting.interpolatd.core;

import java.util.regex.Pattern;
import org.bigtesting.interpolatd.EnclosureClosingHandler;
import org.bigtesting.interpolatd.core.SubstitutionHandlerImpl;

public class EnclosureClosingHandlerImpl<T>
extends SubstitutionHandlerImpl<T>
implements EnclosureClosingHandler<T> {
    private final String opening;
    private final String closing;
    private final Pattern pattern;

    public EnclosureClosingHandlerImpl(String opening, String closing, String characterClass) {
        this.opening = opening;
        this.closing = closing;
        String quotedOpening = Pattern.quote(opening);
        String quotedClosing = Pattern.quote(closing);
        if (characterClass == null) {
            characterClass = "[^" + quotedOpening + quotedClosing + "\\s]+";
        }
        this.pattern = Pattern.compile("(" + quotedOpening + characterClass + quotedClosing + ")");
    }

    @Override
    protected Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected String getCaptured(String found) {
        return found.substring(this.opening.length(), found.length() - this.closing.length());
    }
}

