/*
 * Decompiled with CFR 0.152.
 */
package org.bigtesting.interpolatd.core;

import java.util.regex.Pattern;
import org.bigtesting.interpolatd.PrefixHandler;
import org.bigtesting.interpolatd.core.SubstitutionHandlerImpl;

public class PrefixHandlerImpl<T>
extends SubstitutionHandlerImpl<T>
implements PrefixHandler<T> {
    private final Pattern pattern;
    private final String prefix;

    public PrefixHandlerImpl(String prefix, String characterClass) {
        this.prefix = prefix;
        String quotedPrefix = Pattern.quote(prefix);
        if (characterClass == null) {
            characterClass = "[^" + quotedPrefix + "\\s]+";
        }
        this.pattern = Pattern.compile("(" + quotedPrefix + characterClass + ")");
    }

    @Override
    protected Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected String getCaptured(String found) {
        return found.substring(this.prefix.length());
    }
}

