/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.biouno.unochoice.model.AbstractScript;
import org.biouno.unochoice.model.GroovyScript;
import org.biouno.unochoice.model.ScriptDescriptor;
import org.biouno.unochoice.util.Utils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.builder.ScriptlerBuilder;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ScriptlerScript
extends AbstractScript {
    private static final long serialVersionUID = 6600927513119226354L;
    @Deprecated
    private String scriptlerScriptId;
    @Deprecated
    private Map<String, String> parameters;
    private ScriptlerBuilder scriptlerBuilder;
    private final Boolean isSandboxed;

    @DataBoundConstructor
    public ScriptlerScript(ScriptlerBuilder scriptlerBuilder, Boolean isSandboxed) {
        this.scriptlerBuilder = scriptlerBuilder;
        this.isSandboxed = isSandboxed != null ? isSandboxed : Boolean.TRUE;
    }

    public Object readResolve() {
        if (this.scriptlerBuilder == null) {
            this.scriptlerBuilder = new ScriptlerBuilder("active-choices", this.scriptlerScriptId, false, Arrays.asList(this.getParametersFromDeprecatedMap()));
        }
        return this;
    }

    private Parameter[] getParametersFromDeprecatedMap() {
        if (this.parameters == null) {
            return new Parameter[0];
        }
        return (Parameter[])this.parameters.entrySet().stream().map(entry -> new Parameter((String)entry.getKey(), (String)entry.getValue())).toArray(Parameter[]::new);
    }

    private void initializeFromDeprecatedProperties() {
        if (this.scriptlerBuilder == null) {
            this.readResolve();
        } else {
            String scriptId = this.scriptlerScriptId == null ? this.scriptlerBuilder.getScriptId() : this.scriptlerScriptId;
            Parameter[] parameters = this.parameters == null || this.parameters.isEmpty() ? this.scriptlerBuilder.getParametersList().toArray(new Parameter[0]) : this.getParametersFromDeprecatedMap();
            this.scriptlerBuilder = new ScriptlerBuilder(this.scriptlerBuilder.getBuilderId(), scriptId, this.scriptlerBuilder.isPropagateParams(), Arrays.asList(parameters));
        }
    }

    public ScriptlerBuilder getScriptlerBuilder() {
        return this.scriptlerBuilder;
    }

    public String getScriptlerScriptId() {
        return this.scriptlerBuilder.getScriptId();
    }

    @DataBoundSetter
    public void setScriptlerScriptId(String scriptlerScriptId) {
        this.scriptlerScriptId = scriptlerScriptId;
        this.initializeFromDeprecatedProperties();
    }

    public Map<String, String> getParameters() {
        return Arrays.stream(this.scriptlerBuilder.getParameters()).collect(Collectors.toMap(Parameter::getName, Parameter::getValue));
    }

    @DataBoundSetter
    public void setParameters(List<Map<String, String>> parametersList) {
        this.parameters = parametersList == null ? Collections.emptyMap() : new LinkedHashMap<String, String>(parametersList.stream().filter(Objects::nonNull).filter(map -> map.containsKey("name") && map.containsKey("value")).collect(Collectors.toMap(map -> (String)map.get("name"), map -> (String)map.get("value"))));
        this.initializeFromDeprecatedProperties();
    }

    public Boolean getIsSandboxed() {
        return this.isSandboxed;
    }

    @Override
    public Object eval() {
        return this.eval(null);
    }

    @Override
    public Object eval(Map<String, String> parameters) {
        Map<String, String> envVars = Utils.getSystemEnv();
        LinkedHashMap<String, String> evaledParameters = new LinkedHashMap<String, String>(envVars);
        if (parameters != null && !parameters.isEmpty()) {
            evaledParameters.putAll(parameters);
            for (String key : this.getParameters().keySet()) {
                String value = this.getParameters().get(key);
                value = Util.replaceMacro((String)value, parameters);
                evaledParameters.put(key, value);
            }
        } else {
            evaledParameters.putAll(this.getParameters());
        }
        return this.toGroovyScript().eval(evaledParameters);
    }

    public GroovyScript toGroovyScript() {
        Script scriptler = ScriptHelper.getScript((String)this.getScriptlerScriptId(), (boolean)true);
        if (scriptler == null) {
            throw new RuntimeException("Missing required scriptler!");
        }
        try {
            return new GroovyScript(new SecureGroovyScript(scriptler.script, this.isSandboxed.booleanValue(), null), null);
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException("Failed to create GroovyScript", e);
        }
    }

    @Extension(optional=true)
    @Symbol(value={"scriptlerScript"})
    public static class DescriptorImpl
    extends ScriptDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Scriptler Script";
        }

        private ManagementLink getScriptler() {
            return (ManagementLink)Jenkins.get().getExtensionList(ScriptlerManagement.class).get(0);
        }

        @JavaScriptMethod
        public JSONArray getParameters(String scriptlerScriptId) {
            ScriptlerManagement scriptlerManagement;
            Script script;
            ManagementLink scriptler = this.getScriptler();
            if (scriptler != null && (script = (scriptlerManagement = (ScriptlerManagement)scriptler).getConfiguration().getScriptById(scriptlerScriptId)) != null) {
                return JSONArray.fromObject((Object)script.getParameters());
            }
            return null;
        }

        static {
            ScriptlerManagement.getScriptlerHomeDirectory();
        }
    }
}

