/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.lang.JoseException;

public class X509Util {
    private static final String FACTORY_TYPE = "X.509";
    private CertificateFactory certFactory;
    private Base64 base64 = new Base64();

    public X509Util() {
        try {
            this.certFactory = CertificateFactory.getInstance(FACTORY_TYPE);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Couldn't find X.509 CertificateFactory!?!", e);
        }
    }

    public String toBase64Der(X509Certificate x509Certificate) {
        try {
            byte[] der = x509Certificate.getEncoded();
            return this.base64.encodeToString(der);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("Unexpected problem getting encoded certificate.", e);
        }
    }

    public X509Certificate fromBase64Der(String b64EncodedDer) throws JoseException {
        byte[] der = this.base64.decode(b64EncodedDer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(der);
        try {
            Certificate certificate = this.certFactory.generateCertificate(byteArrayInputStream);
            return (X509Certificate)certificate;
        }
        catch (CertificateException e) {
            throw new JoseException("Unable to convert " + b64EncodedDer + " value to X509Certificate: " + e, e);
        }
    }
}

