/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.database.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.bonitasoft.connectors.database.Database;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class JdbcConnector
implements Connector {
    public static final String RESULTSET_OUTPUT = "resultset";
    public static final String SINGLE_RESULT_OUTPUT = "singleResult";
    public static final String ONEROW_NCOL_RESULT_OUTPUT = "oneRowNColResult";
    public static final String NROW_ONECOL_RESULT_OUTPUT = "nRowOneColResult";
    public static final String TABLE_RESULT_OUTPUT = "tableResult";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SCRIPT = "script";
    public static final String SEPARATOR = "separator";
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String OUTPUT_TYPE = "outputType";
    public static final String SINGLE = "single";
    public static final String N_ROW = "n_row";
    public static final String ONE_ROW = "one_row";
    public static final String TABLE = "table";
    private String url;
    private String userName;
    private String password;
    private String driver;
    private String separator;
    private String script;
    private String outputType;
    private Database database;
    private ResultSet data;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public Map<String, Object> execute() throws ConnectorException {
        if (this.separator != null) {
            return this.executeBatch();
        }
        return this.executeSingleQuery();
    }

    public void setInputParameters(Map<String, Object> parameters) {
        this.userName = (String)parameters.get(USERNAME);
        this.LOGGER.info("username " + this.userName);
        String paswordString = (String)parameters.get(PASSWORD);
        this.LOGGER.info("password ******");
        this.password = paswordString != null && !paswordString.isEmpty() ? paswordString : null;
        this.script = (String)parameters.get(SCRIPT);
        this.LOGGER.info("script " + this.script);
        this.separator = (String)parameters.get(SEPARATOR);
        this.LOGGER.info("separator " + this.separator);
        this.driver = (String)parameters.get(DRIVER);
        this.LOGGER.info("driver " + this.driver);
        this.url = (String)parameters.get(URL);
        this.LOGGER.info("url " + this.url);
        this.outputType = (String)parameters.get(OUTPUT_TYPE);
        this.LOGGER.info("outputType " + this.outputType);
    }

    public void validateInputParameters() throws ConnectorValidationException {
        ArrayList<String> messages = new ArrayList<String>(0);
        if (this.url == null || this.url.isEmpty()) {
            messages.add("Url can't be empty");
        }
        if (this.driver == null || this.driver.isEmpty()) {
            messages.add("Driver is not set");
        }
        if (this.script == null || this.script.isEmpty()) {
            messages.add("Script is not set");
        }
        if (!messages.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, messages);
        }
    }

    public void connect() throws ConnectorException {
        try {
            this.database = new Database(this.driver, this.url, this.userName, this.password);
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void disconnect() throws ConnectorException {
        if (this.script.toUpperCase().trim().startsWith("SELECT")) {
            try {
                if (this.data != null) {
                    this.data.close();
                }
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
        }
        if (this.database != null) {
            try {
                this.database.disconnect();
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
        }
    }

    private Map<String, Object> executeSingleQuery() throws ConnectorException {
        try {
            String command = this.script.toUpperCase().trim();
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            if (command.startsWith("SELECT")) {
                this.data = this.database.select(this.script);
                if (SINGLE.equals(this.outputType)) {
                    this.handleSingleResult(this.data, result);
                } else if (N_ROW.equals(this.outputType)) {
                    this.handleNRowResult(this.data, result);
                } else if (ONE_ROW.equals(this.outputType)) {
                    this.handleOneRowResult(this.data, result);
                } else if (TABLE.equals(this.outputType)) {
                    this.handleTableResult(this.data, result);
                } else {
                    result.put(RESULTSET_OUTPUT, this.data);
                }
            } else {
                this.database.executeCommand(this.script);
                result.put(RESULTSET_OUTPUT, null);
            }
            return result;
        }
        catch (SQLException sqle) {
            throw new ConnectorException((Throwable)sqle);
        }
    }

    protected void handleTableResult(ResultSet rSet, Map<String, Object> result) throws SQLException {
        ArrayList resultTable = new ArrayList();
        int maxColumn = rSet.getMetaData().getColumnCount() + 1;
        while (rSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int colIndex = 1; colIndex < maxColumn; ++colIndex) {
                row.add(rSet.getObject(colIndex));
            }
            resultTable.add(row);
        }
        result.put(TABLE_RESULT_OUTPUT, resultTable);
        rSet.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleOneRowResult(ResultSet rSet, Map<String, Object> result) throws SQLException, ConnectorException {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (rSet.first()) {
            if (!rSet.isLast()) {
                rSet.close();
                throw new ConnectorException("One row N columns result output mode is not compatible with execucted query (invalid number of rows in resultset):\n" + this.script);
            }
            int maxColumn = rSet.getMetaData().getColumnCount() + 1;
            for (int colIndex = 1; colIndex < maxColumn; ++colIndex) {
                resultList.add(rSet.getObject(colIndex));
            }
            result.put(ONEROW_NCOL_RESULT_OUTPUT, resultList);
        } else {
            result.put(ONEROW_NCOL_RESULT_OUTPUT, resultList);
        }
        rSet.close();
    }

    protected void handleNRowResult(ResultSet rSet, Map<String, Object> result) throws SQLException, ConnectorException {
        int colCount = rSet.getMetaData().getColumnCount();
        if (colCount != 1) {
            rSet.close();
            throw new ConnectorException("N rows one column result output mode is not compatible with execucted query (invalid number of columns in resultset):\n" + this.script);
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        while (rSet.next()) {
            resultList.add(rSet.getObject(1));
        }
        result.put(NROW_ONECOL_RESULT_OUTPUT, resultList);
        rSet.close();
    }

    protected void handleSingleResult(ResultSet rSet, Map<String, Object> result) throws SQLException, ConnectorException {
        int colCount = rSet.getMetaData().getColumnCount();
        if (colCount != 1) {
            rSet.close();
            throw new ConnectorException("Single result output mode is not compatible with execucted query (invalid number of columns in resultset):\n" + this.script);
        }
        if (rSet.first()) {
            result.put(SINGLE_RESULT_OUTPUT, rSet.getObject(1));
        } else {
            result.put(SINGLE_RESULT_OUTPUT, null);
        }
        rSet.close();
    }

    private Map<String, Object> executeBatch() throws ConnectorException {
        List<String> commands = this.getScriptCommands();
        try {
            this.database.executeBatch(commands, true);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(RESULTSET_OUTPUT, null);
            return result;
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private List<String> getScriptCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.script, this.separator);
        while (tokenizer.hasMoreTokens()) {
            String command = tokenizer.nextToken();
            commands.add(command.trim());
        }
        return commands;
    }
}

