/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.document.converter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class InputParametersValidator {
    private static final String INPUT_PARAMETER_TYPE_ERROR_MESSAGE_PATTERN = "Input parameter %s must be of type %s.";
    private final Map<String, Object> inputParameters;

    public InputParametersValidator(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void validateInputParameters() throws ConnectorValidationException {
        this.validateSourceDocumentInput();
        this.validateOutputFileName();
        this.validateEncoding();
    }

    private void validateSourceDocumentInput() throws ConnectorValidationException {
        Object sourceDocumentName = this.inputParameters.get("sourceDocument");
        if (sourceDocumentName == null) {
            throw new ConnectorValidationException(String.format("Input parameter %s cannot be null.", "sourceDocument"));
        }
        if (!(sourceDocumentName instanceof String)) {
            throw new ConnectorValidationException(String.format(INPUT_PARAMETER_TYPE_ERROR_MESSAGE_PATTERN, "sourceDocument", String.class.getName()));
        }
        if (((String)sourceDocumentName).isEmpty()) {
            throw new ConnectorValidationException(String.format("Input parameter %s cannot be empty.", "sourceDocument"));
        }
    }

    private void validateOutputFileName() throws ConnectorValidationException {
        Object outputFileName = this.inputParameters.get("outputFileName");
        if (outputFileName != null && !(outputFileName instanceof String)) {
            throw new ConnectorValidationException(String.format(INPUT_PARAMETER_TYPE_ERROR_MESSAGE_PATTERN, "outputFileName", String.class.getName()));
        }
        if (outputFileName != null && !this.isValidFileName((String)outputFileName)) {
            throw new ConnectorValidationException(String.format("Input parameter %s has an invalid value: %s. You must specify a valid file name.", "outputFileName", outputFileName));
        }
    }

    private boolean isValidFileName(String outputFileName) {
        File f = new File(outputFileName);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void validateEncoding() throws ConnectorValidationException {
        Object encoding = this.inputParameters.get("encoding");
        if (encoding != null && !(encoding instanceof String)) {
            throw new ConnectorValidationException(String.format(INPUT_PARAMETER_TYPE_ERROR_MESSAGE_PATTERN, "outputFileName", String.class.getName()));
        }
        if (encoding != null && !Charset.isSupported((String)encoding)) {
            throw new ConnectorValidationException(String.format("Input parameter %s has an invalid value: %s is not a supported encoding.", "encoding", encoding));
        }
    }
}

