/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.document.converter.core;

import java.io.InputStream;
import org.bonitasoft.connectors.document.converter.core.DocToHTMLConverter;
import org.bonitasoft.connectors.document.converter.core.DocToPDFConverter;
import org.bonitasoft.connectors.document.converter.core.DocumentConverter;

public class DocumentConverterFactory {
    public static final String PDF = "PDF";
    public static final String XHTML = "XHTML";

    public DocumentConverter newConverter(InputStream is, String outputFormat, String encoding) {
        switch (outputFormat) {
            case "PDF": {
                return new DocToPDFConverter(is, encoding);
            }
            case "XHTML": {
                return new DocToHTMLConverter(is, encoding);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown output format: %s. Supported formats are %s, %s", outputFormat, PDF, XHTML));
    }
}

