/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.model.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.connectors.google.calendar.common.BuildEventConnector;
import org.bonitasoft.engine.connector.ConnectorException;

public class UpdateEventConnector
extends BuildEventConnector {
    @Override
    protected List<String> checkParameters() {
        ArrayList<String> errors = new ArrayList<String>();
        this.ensureIdInputIsSpecified(errors);
        return errors;
    }

    @Override
    protected void doJobWithCalendarEvents(Calendar.Events events) throws ConnectorException {
        try {
            Event event = (Event)events.get(this.getCalendarId(), this.getId()).execute();
            this.buildEvent(event);
            Calendar.Events.Update update = events.update(this.getCalendarId(), event.getId(), event);
            this.setCommonInputs((CalendarRequest<Event>)update);
            if (this.getSendNotifications() != null) {
                update.setSendNotifications(this.getSendNotifications());
            }
            if (this.getMaxAttendees() != null) {
                update.setMaxAttendees(this.getMaxAttendees());
            }
            this.setOutputParameters((Event)update.execute());
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

