/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.google.calendar.common;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.model.Event;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public abstract class CalendarConnector
extends AbstractConnector {
    public static final String APPLICATION_NAME = "applicationName";
    public static final String CALENDAR_ID = "calendarId";
    public static final String AUTH_MODE = "authMode";
    public static final String SERVICE_ACCOUNT_ID = "serviceAccountId";
    public static final String SERVICE_ACCOUNT_JSON_TOKEN = "serviceAccountJsonToken";
    public static final String SERVICE_ACCOUNT_P12_FILE = "serviceAccountP12File";
    public static final String SERVICE_ACCOUNT_USER = "serviceAccountUser";
    public static final String INPUT_ID = "id";
    public static final String INPUT_PRETTY_PRINT = "prettyPrint";
    public static final String INPUT_MAX_ATTENDEES = "maxAttendees";
    public static final String INPUT_SEND_NOTIFICATIONS = "sendNotifications";
    public static final String OUTPUT_EVENT = "event";
    public static final String OUTPUT_ETAG = "etag";
    public static final String OUTPUT_HANGOUT_LINK = "hangoutLink";
    public static final String OUTPUT_HTML_LINK = "htmlLink";
    public static final String OUTPUT_I_CAL_UID = "iCalUID";
    public static final String OUTPUT_ID = "id";
    public static final String OUTPUT_STATUS = "status";
    public static final String OUTPUT_SUMMARY = "summary";
    public static final String OUTPUT_DESCRIPTION = "description";
    public static final String OUTPUT_LOCATION = "location";
    public static final String OUTPUT_TRANSPARENCY = "transparency";
    public static final String OUTPUT_VISIBILITY = "visibility";
    public static final String OUTPUT_SEQUENCE = "sequence";
    public static final String OUTPUT_ANYONE_CAN_ADD_SELF = "anyoneCanAddSelf";
    public static final String OUTPUT_GUESTS_CAN_INVITE_OTHERS = "guestsCanInviteOthers";
    public static final String OUTPUT_GUESTS_CAN_MODIFY = "guestsCanModify";
    public static final String OUTPUT_GUESTS_CAN_SEE_OTHER_GUESTS = "guestsCanSeeOtherGuests";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();

    public void validateInputParameters() throws ConnectorValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        this.validateAuthenticationInputs(errors);
        if (this.getServiceAccountId() == null || this.getServiceAccountId().isEmpty()) {
            errors.add("Service Account ID must be set.");
        }
        if (this.getCalendarId() == null || this.getCalendarId().isEmpty()) {
            errors.add("CalendarId must be set.");
        }
        errors.addAll(this.checkParameters());
        if (!errors.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, errors);
        }
    }

    private void validateAuthenticationInputs(List<String> errors) throws ConnectorValidationException {
        if (this.getAuthMode() == null) {
            throw new ConnectorValidationException((Connector)this, new String[]{"Authentication mode must be set."});
        }
        try {
            AuthMode.valueOf(this.getAuthMode());
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorValidationException((Connector)this, new String[]{"Supported authentication mode are: " + Stream.of(AuthMode.values()).map(Enum::name).collect(Collectors.joining(", "))});
        }
        AuthMode authMode = AuthMode.valueOf(this.getAuthMode());
        if (authMode == AuthMode.P12) {
            this.validateP12AuthInputs(errors);
        } else if (authMode == AuthMode.JSON && (this.getServiceAccountJsonToken() == null || this.getServiceAccountJsonToken().isEmpty())) {
            errors.add("A Service Account credential using a Json token must be set.");
        }
    }

    private void validateP12AuthInputs(List<String> errors) {
        if (this.getServiceAccountP12File() == null || this.getServiceAccountP12File().isEmpty()) {
            errors.add("A Service Account credential using a p12 file (legacy) must be set.");
        } else {
            File p12File = new File(this.getServiceAccountP12File());
            if (!p12File.exists()) {
                errors.add("Service Account P12 File refers to a non existing file: " + this.getServiceAccountP12File() + ".");
            } else if (p12File.isDirectory()) {
                errors.add("Service Account P12 File refers to a directory and not a file: " + this.getServiceAccountP12File() + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBusinessLogic() throws ConnectorException {
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            try {
                AuthMode authMode = AuthMode.valueOf(this.getAuthMode());
                GoogleCredential requestInitializer = null;
                if (authMode == AuthMode.JSON) {
                    try (ByteArrayInputStream jsonTokenStream = new ByteArrayInputStream(this.getServiceAccountJsonToken().getBytes());){
                        requestInitializer = new HttpCredentialsAdapter((Credentials)ServiceAccountCredentials.fromStream((InputStream)jsonTokenStream).toBuilder().setServiceAccountUser(this.getServiceAccountUser()).build().createScoped(new String[]{"https://www.googleapis.com/auth/calendar"}));
                    }
                } else if (authMode == AuthMode.P12) {
                    requestInitializer = new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId(this.getServiceAccountId()).setServiceAccountUser(this.getServiceAccountUser()).setServiceAccountPrivateKeyFromP12File(new File(this.getServiceAccountP12File())).build().createScoped(Collections.singleton("https://www.googleapis.com/auth/calendar"));
                }
                Calendar calendar = new Calendar.Builder((HttpTransport)httpTransport, JSON_FACTORY, requestInitializer).setApplicationName(this.getApplicationName()).build();
                this.doJobWithCalendarEvents(calendar.events());
            }
            finally {
                httpTransport.shutdown();
            }
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    protected void ensureIdInputIsSpecified(List<String> errors) {
        if (this.getId() == null) {
            errors.add("Event Id must be set.");
        }
    }

    protected abstract void doJobWithCalendarEvents(Calendar.Events var1) throws ConnectorException;

    protected abstract List<String> checkParameters();

    public String getCalendarId() {
        return (String)this.getInputParameter(CALENDAR_ID);
    }

    public String getAuthMode() {
        return (String)this.getInputParameter(AUTH_MODE);
    }

    public String getApplicationName() {
        return (String)this.getInputParameter(APPLICATION_NAME);
    }

    public String getServiceAccountId() {
        return (String)this.getInputParameter(SERVICE_ACCOUNT_ID);
    }

    public String getServiceAccountJsonToken() {
        return (String)this.getInputParameter(SERVICE_ACCOUNT_JSON_TOKEN);
    }

    public String getServiceAccountP12File() {
        return (String)this.getInputParameter(SERVICE_ACCOUNT_P12_FILE);
    }

    public String getServiceAccountUser() {
        return (String)this.getInputParameter(SERVICE_ACCOUNT_USER);
    }

    protected Boolean getPrettyPrint() {
        return (Boolean)this.getInputParameter(INPUT_PRETTY_PRINT);
    }

    protected Integer getMaxAttendees() {
        return (Integer)this.getInputParameter(INPUT_MAX_ATTENDEES);
    }

    protected String getId() {
        return (String)this.getInputParameter("id");
    }

    protected Boolean getSendNotifications() {
        return (Boolean)this.getInputParameter(INPUT_SEND_NOTIFICATIONS);
    }

    protected void setCommonInputs(CalendarRequest<Event> request) {
        if (this.getPrettyPrint() != null) {
            request.setPrettyPrint(this.getPrettyPrint());
        }
    }

    protected void setOutputParameters(Event event) {
        if (event != null) {
            this.setOutputParameter(OUTPUT_EVENT, event.toString());
            this.setOutputParameter(OUTPUT_ETAG, event.getEtag());
            this.setOutputParameter(OUTPUT_HANGOUT_LINK, event.getHangoutLink());
            this.setOutputParameter(OUTPUT_HTML_LINK, event.getHtmlLink());
            this.setOutputParameter(OUTPUT_I_CAL_UID, event.getICalUID());
            this.setOutputParameter("id", event.getId());
            this.setOutputParameter(OUTPUT_STATUS, event.getStatus());
            this.setOutputParameter(OUTPUT_SUMMARY, event.getSummary());
            this.setOutputParameter(OUTPUT_DESCRIPTION, event.getDescription());
            this.setOutputParameter(OUTPUT_LOCATION, event.getLocation());
            this.setOutputParameter(OUTPUT_TRANSPARENCY, event.getTransparency());
            this.setOutputParameter(OUTPUT_VISIBILITY, event.getVisibility());
            this.setOutputParameter(OUTPUT_SEQUENCE, event.getSequence());
            this.setOutputParameter(OUTPUT_ANYONE_CAN_ADD_SELF, event.getAnyoneCanAddSelf());
            this.setOutputParameter(OUTPUT_GUESTS_CAN_INVITE_OTHERS, event.getGuestsCanInviteOthers());
            this.setOutputParameter(OUTPUT_GUESTS_CAN_MODIFY, event.getGuestsCanModify());
            this.setOutputParameter(OUTPUT_GUESTS_CAN_SEE_OTHER_GUESTS, event.getGuestsCanSeeOtherGuests());
        }
    }

    static enum AuthMode {
        JSON,
        P12;

    }
}

