/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.bonitasoft.engine.api.BonitaStackTraceElementConverter;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.http.BonitaResponseHandler;

public class HTTPServerAPI
implements ServerAPI {
    private static final String UTF_8 = "UTF-8";
    private static final String CLASS_NAME_PARAMETERS = "classNameParameters";
    private static final String OPTIONS = "options";
    private static final String PARAMETERS_VALUES = "parametersValues";
    private static final String BINARY_PARAMETER = "binaryParameter";
    private static final String BYTE_ARRAY = "==ByteArray==";
    private static final char SLASH = '/';
    private static final String SERVER_API = "/serverAPI/";
    private static final long serialVersionUID = 1L;
    private static final String SERVER_URL = "server.url";
    private static final String BASIC_AUTHENTICATION_ACTIVE = "basicAuthentication.active";
    private static final String BASIC_AUTHENTICATION_USERNAME = "basicAuthentication.username";
    private static final String BASIC_AUTHENTICATION_PASSWORD = "basicAuthentication.password";
    private static final String APPLICATION_NAME = "application.name";
    private static final Logger LOGGER = Logger.getLogger(HTTPServerAPI.class.getName());
    private String serverUrl = null;
    private String applicationName = null;
    private boolean basicAuthenticationActive = false;
    private String basicAuthenticationUserName = null;
    private String basicAuthenticationPassword = null;
    private static DefaultHttpClient httpclient;
    private static final XStream xstream;
    private static final ResponseHandler<String> responseHandler;

    public HTTPServerAPI(Map<String, String> parameters) {
        if (httpclient == null) {
            httpclient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        }
        this.serverUrl = parameters.get(SERVER_URL);
        this.applicationName = parameters.get(APPLICATION_NAME);
        this.basicAuthenticationActive = "true".equalsIgnoreCase(parameters.get(BASIC_AUTHENTICATION_ACTIVE));
        this.basicAuthenticationUserName = parameters.get(BASIC_AUTHENTICATION_USERNAME);
        this.basicAuthenticationPassword = parameters.get(BASIC_AUTHENTICATION_PASSWORD);
    }

    public Object invokeMethod(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws ServerWrappedException {
        String response = null;
        try {
            response = this.executeHttpPost(options, apiInterfaceName, methodName, classNameParameters, parametersValues, xstream);
            return this.checkInvokeMethodReturn(response, xstream);
        }
        catch (UndeclaredThrowableException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
            throw new ServerWrappedException((Throwable)e);
        }
        catch (Throwable e) {
            throw new ServerWrappedException(e.getMessage() + "response= " + response, e);
        }
    }

    private Object checkInvokeMethodReturn(String response, XStream xstream) throws Throwable {
        Object invokeMethodReturn = null;
        if (response != null && !response.isEmpty() && !response.equals("null") && (invokeMethodReturn = this.fromXML(response, xstream)) instanceof Throwable) {
            throw (Throwable)invokeMethodReturn;
        }
        return invokeMethodReturn;
    }

    private String executeHttpPost(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues, XStream xstream) throws UnsupportedEncodingException, IOException, ClientProtocolException {
        HttpPost httpost = this.createHttpPost(options, apiInterfaceName, methodName, classNameParameters, parametersValues, xstream);
        return (String)httpclient.execute((HttpUriRequest)httpost, responseHandler);
    }

    private HttpPost createHttpPost(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues, XStream xstream) throws UnsupportedEncodingException, IOException {
        HttpEntity httpEntity = this.buildEntity(options, classNameParameters, parametersValues, xstream);
        StringBuilder sBuilder = new StringBuilder(this.serverUrl);
        sBuilder.append('/').append(this.applicationName).append(SERVER_API).append(apiInterfaceName).append('/').append(methodName);
        HttpPost httpost = new HttpPost(sBuilder.toString());
        httpost.setEntity(httpEntity);
        if (this.basicAuthenticationActive) {
            StringBuilder credentials = new StringBuilder();
            credentials.append(this.basicAuthenticationUserName).append(":").append(this.basicAuthenticationPassword);
            Base64 encoder = new Base64();
            String encodedCredentials = encoder.encodeAsString(credentials.toString().getBytes());
            httpost.setHeader("Authorization", "Basic " + encodedCredentials);
        }
        return httpost;
    }

    private HttpEntity buildEntity(Map<String, Serializable> options, List<String> classNameParameters, Object[] parametersValues, XStream xstream) throws UnsupportedEncodingException, IOException {
        UrlEncodedFormEntity httpEntity;
        if (classNameParameters.contains(BusinessArchive.class.getName()) || classNameParameters.contains(byte[].class.getName())) {
            int i;
            ArrayList<Object> bytearrayParameters = new ArrayList<Object>();
            MultipartEntity entity = new MultipartEntity();
            entity.addPart(OPTIONS, (ContentBody)new StringBody(this.toXML(options, xstream)));
            entity.addPart(CLASS_NAME_PARAMETERS, (ContentBody)new StringBody(this.toXML(classNameParameters, xstream)));
            for (i = 0; i < parametersValues.length; ++i) {
                Object parameterValue = parametersValues[i];
                if (!(parameterValue instanceof BusinessArchive) && !(parameterValue instanceof byte[])) continue;
                parametersValues[i] = BYTE_ARRAY;
                bytearrayParameters.add(parameterValue);
            }
            entity.addPart(PARAMETERS_VALUES, (ContentBody)new StringBody(this.toXML(parametersValues, xstream)));
            i = 0;
            for (Object e : bytearrayParameters) {
                entity.addPart(BINARY_PARAMETER + i, (ContentBody)new ByteArrayBody(this.serialize(e), BINARY_PARAMETER + i));
                ++i;
            }
            httpEntity = entity;
        } else {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair(OPTIONS, this.toXML(options, xstream)));
            nvps.add(new BasicNameValuePair(CLASS_NAME_PARAMETERS, this.toXML(classNameParameters, xstream)));
            nvps.add(new BasicNameValuePair(PARAMETERS_VALUES, this.toXML(parametersValues, xstream)));
            httpEntity = new UrlEncodedFormEntity(nvps, UTF_8);
        }
        return httpEntity;
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        return b.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }

    private String toXML(Object options, XStream xstream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        ObjectOutputStream out = xstream.createObjectOutputStream((Writer)stringWriter);
        out.writeObject(options);
        out.close();
        return stringWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T fromXML(String object, XStream xstream) {
        StringReader xmlReader = new StringReader(object);
        ObjectInputStream in = null;
        try {
            in = xstream.createObjectInputStream((Reader)xmlReader);
            try {
                Object object2 = in.readObject();
                return (T)object2;
            }
            catch (IOException e) {
                throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
            }
            catch (CannotResolveClassException e) {
                throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
            }
            finally {
                in.close();
                xmlReader.close();
            }
        }
        catch (IOException e) {
            throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
        }
    }

    static {
        responseHandler = new BonitaResponseHandler();
        xstream = new XStream();
        xstream.registerConverter((SingleValueConverter)new BonitaStackTraceElementConverter(), 10000);
    }
}

