/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.bpm.actor.impl.ActorDefinitionImpl;
import org.bonitasoft.engine.bpm.bar.xml.NamedElementBinding;
import org.bonitasoft.engine.bpm.bar.xml.StringIndex;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.parameter.ParameterDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.impl.DesignProcessDefinitionImpl;

public class ProcessDefinitionBinding
extends NamedElementBinding {
    private String version;
    private final List<ActorDefinitionImpl> actors = new ArrayList<ActorDefinitionImpl>();
    private String actorInitiatorName;
    private final Set<ParameterDefinition> parameters = new HashSet<ParameterDefinition>();
    private DesignProcessDefinitionImpl processDefinitionImpl;
    private String displayDescription;
    private String displayName;
    private FlowElementContainerDefinition processContainer;
    private final List<StringIndex> stringIndexes = new ArrayList<StringIndex>(5);

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        this.version = attributes.get("version");
        this.displayName = attributes.get("displayName");
        this.displayDescription = attributes.get("displayDescription");
    }

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
    }

    @Override
    public void setChildObject(String name, Object value) {
        if ("actor".equals(name)) {
            this.actors.add((ActorDefinitionImpl)value);
        } else if ("actorInitiator".equals(name)) {
            this.actorInitiatorName = (String)value;
        } else if ("parameter".equals(name)) {
            this.parameters.add((ParameterDefinition)value);
        } else if ("flowElements".equals(name)) {
            this.processContainer = (FlowElementContainerDefinition)value;
        } else if ("stringIndex".equals(name)) {
            this.stringIndexes.add((StringIndex)value);
        }
    }

    @Override
    public DesignProcessDefinition getObject() {
        if (this.processDefinitionImpl == null) {
            this.processDefinitionImpl = new DesignProcessDefinitionImpl(this.name, this.version);
            this.processDefinitionImpl.setDescription(this.description);
            this.processDefinitionImpl.setDisplayName(this.displayName);
            this.processDefinitionImpl.setDisplayDescription(this.displayDescription);
            for (StringIndex stringIndex : this.stringIndexes) {
                this.processDefinitionImpl.setStringIndex(stringIndex.getIndex(), stringIndex.getLabel(), stringIndex.getValue());
            }
            for (ActorDefinitionImpl actor : this.actors) {
                if (this.actorInitiatorName != null && this.actorInitiatorName.equals(actor.getName())) {
                    actor.setInitiator(true);
                    this.processDefinitionImpl.setActorInitiator(actor);
                }
                this.processDefinitionImpl.addActor(actor);
            }
            for (ParameterDefinition parameter : this.parameters) {
                this.processDefinitionImpl.addParameter(parameter);
            }
            if (this.processContainer != null) {
                this.processDefinitionImpl.setProcessContainer(this.processContainer);
            }
        }
        return this.processDefinitionImpl;
    }

    @Override
    public String getElementTag() {
        return "processDefinition";
    }
}

