/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.document;

import java.io.Serializable;
import java.util.Arrays;

public class DocumentValue
implements Serializable {
    private static final long serialVersionUID = -637083535741620642L;
    private byte[] content;
    private String mimeType;
    private String fileName;
    private String url;
    private final boolean hasContent;

    public DocumentValue(byte[] content, String mimeType, String fileName) {
        this.content = content;
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.hasContent = true;
    }

    public DocumentValue(String url) {
        this.url = url;
        this.hasContent = false;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.content);
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.hasContent ? 1231 : 1237);
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentValue other = (DocumentValue)obj;
        if (!Arrays.equals(this.content, other.content)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.hasContent != other.hasContent) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "DocumentValue [content=" + Arrays.toString(this.content) + ", mimeType=" + this.mimeType + ", fileName=" + this.fileName + ", url=" + this.url + ", hasContent=" + this.hasContent + "]";
    }
}

