/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.EngineExecutionContext;

public abstract class AbstractConnector
implements Connector {
    private final Map<String, Object> inputParameters = new HashMap<String, Object>();
    private final Map<String, Object> outputParameters = new HashMap<String, Object>();
    protected APIAccessor apiAccessor;
    private EngineExecutionContext executionContext;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        this.inputParameters.putAll(parameters);
    }

    protected Object getInputParameter(String paramName) {
        return this.inputParameters.get(paramName);
    }

    protected Object getInputParameter(String parameterKey, Serializable defaultValue) {
        Object param = this.getInputParameter(parameterKey);
        return param == null ? defaultValue : param;
    }

    protected void setOutputParameter(String paramName, Object value) {
        this.outputParameters.put(paramName, value);
    }

    protected Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public final Map<String, Object> execute() throws ConnectorException {
        this.executeBusinessLogic();
        return this.getOutputParameters();
    }

    @Override
    public void connect() throws ConnectorException {
    }

    @Override
    public void disconnect() throws ConnectorException {
    }

    protected abstract void executeBusinessLogic() throws ConnectorException;

    public void setAPIAccessor(APIAccessor apiAccessor) {
        this.apiAccessor = apiAccessor;
    }

    public APIAccessor getAPIAccessor() {
        return this.apiAccessor;
    }

    public EngineExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(EngineExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

