/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.identity.ContactDataUpdater;

public class UserUpdater
implements Serializable {
    private static final long serialVersionUID = 4565052647320534796L;
    private final Map<UserField, Serializable> fields = new HashMap<UserField, Serializable>(5);
    private ContactDataUpdater persoContactUpdater;
    private ContactDataUpdater proContactUpdater;

    public UserUpdater setUserName(String name) {
        this.fields.put(UserField.USER_NAME, (Serializable)((Object)name));
        return this;
    }

    public UserUpdater setPassword(String password) {
        this.fields.put(UserField.PASSWORD, (Serializable)((Object)password));
        return this;
    }

    public UserUpdater setFirstName(String firstName) {
        this.fields.put(UserField.FIRST_NAME, (Serializable)((Object)firstName));
        return this;
    }

    public UserUpdater setLastName(String lastName) {
        this.fields.put(UserField.LAST_NAME, (Serializable)((Object)lastName));
        return this;
    }

    public UserUpdater setIconName(String iconName) {
        this.fields.put(UserField.ICON_NAME, (Serializable)((Object)iconName));
        return this;
    }

    public UserUpdater setManagerId(long managerId) {
        this.fields.put(UserField.MANAGER_ID, Long.valueOf(managerId));
        return this;
    }

    public UserUpdater setIconPath(String iconPath) {
        this.fields.put(UserField.ICON_PATH, (Serializable)((Object)iconPath));
        return this;
    }

    public UserUpdater setTitle(String title) {
        this.fields.put(UserField.TITLE, (Serializable)((Object)title));
        return this;
    }

    public UserUpdater setJobTitle(String jobTitle) {
        this.fields.put(UserField.JOB_TITLE, (Serializable)((Object)jobTitle));
        return this;
    }

    public UserUpdater setEnabled(boolean enabled) {
        this.fields.put(UserField.ENABLED, Boolean.valueOf(enabled));
        return this;
    }

    public Map<UserField, Serializable> getFields() {
        return this.fields;
    }

    public UserUpdater setPersonalContactData(ContactDataUpdater persoContactUpdater) {
        this.persoContactUpdater = persoContactUpdater;
        return this;
    }

    public UserUpdater setProfessionalContactData(ContactDataUpdater proContactUpdater) {
        this.proContactUpdater = proContactUpdater;
        return this;
    }

    public ContactDataUpdater getPersoContactUpdater() {
        return this.persoContactUpdater;
    }

    public ContactDataUpdater getProContactUpdater() {
        return this.proContactUpdater;
    }

    public boolean hasFields() {
        return !this.getFields().isEmpty() || this.getPersoContactUpdater() != null && this.getPersoContactUpdater().hasFields() || this.getProContactUpdater() != null && this.getProContactUpdater().hasFields();
    }

    public static enum UserField {
        USER_NAME,
        PASSWORD,
        FIRST_NAME,
        LAST_NAME,
        ICON_NAME,
        ICON_PATH,
        TITLE,
        JOB_TITLE,
        MANAGER_ID,
        ENABLED;

    }
}

