/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.exception.IncorrectParameterException;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchFilterOperation;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.Sort;
import org.bonitasoft.engine.search.impl.SearchFilter;

public class SearchOptionsImpl
implements SearchOptions {
    private static final long serialVersionUID = 1967932608495889373L;
    private List<SearchFilter> filters = new ArrayList<SearchFilter>(5);
    private String searchTerm;
    private final int startIndex;
    private final int numberOfResults;
    private List<Sort> sorts = new ArrayList<Sort>(2);

    public SearchOptionsImpl(int startIndex, int numberOfResults) {
        this.startIndex = startIndex;
        this.numberOfResults = numberOfResults;
    }

    public void setFilters(List<SearchFilter> filters) {
        this.filters = filters;
    }

    @Override
    public List<SearchFilter> getFilters() {
        return this.filters;
    }

    @Override
    public String getSearchTerm() {
        return this.searchTerm;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getMaxResults() {
        return this.numberOfResults;
    }

    @Override
    public List<Sort> getSorts() {
        return this.sorts;
    }

    public void setSearchTerm(String value) {
        this.searchTerm = value;
    }

    public void addGreaterThanFilter(String field, Serializable value) {
        this.filters.add(new SearchFilter(field, SearchFilterOperation.GREATER_THAN, value));
    }

    public void addGreaterOrEqualsFilter(String field, Serializable value) {
        this.filters.add(new SearchFilter(field, SearchFilterOperation.GREATER_OR_EQUAL, value));
    }

    public void addLessThanFilter(String field, Serializable value) {
        this.filters.add(new SearchFilter(field, SearchFilterOperation.LESS_THAN, value));
    }

    public void addLessOrEqualsFilter(String field, Serializable value) {
        this.filters.add(new SearchFilter(field, SearchFilterOperation.LESS_OR_EQUAL, value));
    }

    public void addBetweenFilter(String field, Serializable from, Serializable to) {
        this.filters.add(new SearchFilter(field, from, to));
    }

    public void addDifferentFromFilter(String field, Serializable value) {
        this.filters.add(new SearchFilter(field, SearchFilterOperation.DIFFERENT, value));
    }

    public void addFilter(String field, Serializable value) {
        this.filters.add(new SearchFilter(field, SearchFilterOperation.EQUALS, value));
    }

    public final void addOrFilter() {
        try {
            this.filters.add(new SearchFilter(SearchFilterOperation.OR));
        }
        catch (IncorrectParameterException incorrectParameterException) {
            // empty catch block
        }
    }

    public final void addAndFilter() {
        try {
            this.filters.add(new SearchFilter(SearchFilterOperation.AND));
        }
        catch (IncorrectParameterException incorrectParameterException) {
            // empty catch block
        }
    }

    public final void addLeftParenthesis() {
        try {
            this.filters.add(new SearchFilter(SearchFilterOperation.L_PARENTHESIS));
        }
        catch (IncorrectParameterException incorrectParameterException) {
            // empty catch block
        }
    }

    public final void addRightParenthesis() {
        try {
            this.filters.add(new SearchFilter(SearchFilterOperation.R_PARENTHESIS));
        }
        catch (IncorrectParameterException incorrectParameterException) {
            // empty catch block
        }
    }

    public void addSort(String field, Order order) {
        this.sorts.add(new Sort(order, field));
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }
}

