/**
 * Copyright (C) 2019 Bonitasoft S.A.
 * Bonitasoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.bpm.contract;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

/**
 * @author Baptiste Mesta
 */
public class FileInputValue implements Serializable {

    private static final long serialVersionUID = 1L;
    private String id;
    private String fileName;
    private byte[] content;
    private String contentType;

    public FileInputValue(String fileName, byte[] content) {
        this(fileName, null, content, null);
    }

    public FileInputValue(String fileName, String contentType, byte[] content) {
        this(fileName, contentType, content, null);
    }

    public FileInputValue(String fileName, String contentType, byte[] content, String id) {
        this.id = id;
        this.fileName = fileName;
        this.contentType = contentType;
        this.content = content;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getContent() {
        return content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return "FileInputValue{" +
                "id='" + id + '\'' +
                "fileName='" + fileName + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        final FileInputValue that = (FileInputValue) o;
        return Objects.equals(id, that.id) && Objects.equals(fileName, that.fileName) &&
                Arrays.equals(content, that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fileName, content);
    }
}
