/**
 * Copyright (C) 2019 Bonitasoft S.A.
 * Bonitasoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.document.impl.DocumentDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;

/**
 * @author Baptiste Mesta
 * @author Matthieu Chaffotte
 */
public class DocumentDefinitionBuilder extends FlowElementContainerBuilder {

    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";

    private final DocumentDefinitionImpl documentDefinitionImpl;

    @Deprecated
    public DocumentDefinitionBuilder(final ProcessDefinitionBuilder processDefinitionBuilder,
            final FlowElementContainerDefinitionImpl container,
            final String name, final String fileName) {
        this(processDefinitionBuilder, container, name);
        documentDefinitionImpl.setFileName(fileName);
    }

    public DocumentDefinitionBuilder(final ProcessDefinitionBuilder processDefinitionBuilder,
            final FlowElementContainerDefinitionImpl container,
            final String name) {
        super(container, processDefinitionBuilder);
        documentDefinitionImpl = new DocumentDefinitionImpl(name);
        documentDefinitionImpl.setMimeType(DEFAULT_MIME_TYPE);
        container.addDocumentDefinition(documentDefinitionImpl);
    }

    /**
     * Sets description on this document
     *
     * @param description description
     * @return the builder
     */
    public DocumentDefinitionBuilder addDescription(final String description) {
        documentDefinitionImpl.setDescription(description);
        return this;
    }

    /**
     * Adds URL on this document
     *
     * @param url URL
     * @return
     */
    public DocumentDefinitionBuilder addUrl(final String url) {
        if (documentDefinitionImpl.getFile() == null) {
            documentDefinitionImpl.setUrl(url);
        } else {
            getProcessBuilder()
                    .addError("Unable to add an url on a document that already have a file " + documentDefinitionImpl);
        }
        return this;
    }

    /**
     * Adds content file name on this document
     *
     * @param contentFilename content file name
     * @return
     */
    public DocumentDefinitionBuilder addContentFileName(final String contentFilename) {
        if (documentDefinitionImpl.getFileName() == null) {
            documentDefinitionImpl.setFileName(contentFilename);
        } else {
            getProcessBuilder().addError(
                    "Unable to add file name on a document that already have a file name " + documentDefinitionImpl);
        }
        return this;
    }

    /**
     * Adds a file on this document
     *
     * @param file the complete file name
     * @return
     */
    public DocumentDefinitionBuilder addFile(final String file) {
        if (documentDefinitionImpl.getUrl() == null) {
            documentDefinitionImpl.setFile(file);
        } else {
            getProcessBuilder().addError("Unable to add a file on a document that already have an url");
        }
        return this;
    }

    public DocumentDefinitionBuilder addMimeType(final String mimeType) {
        documentDefinitionImpl.setMimeType(mimeType);
        return this;
    }

    /**
     * Adds an initial value to the document, the initial value must be a
     * <code>org.bonitasoft.engine.bpm.document.DocumentValue</code> or a
     * {@link org.bonitasoft.engine.bpm.contract.FileInputValue}
     * It overrides any value put in mime type, file, url or filename.
     *
     * @param expression that is the initial value
     * @return the builder
     * @since 7.0.0
     */
    public DocumentDefinitionBuilder addInitialValue(final Expression expression) {
        documentDefinitionImpl.setInitialValue(expression);
        return this;
    }

}
