/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, CMSSignedDataGenerator.getSignerIdentifier(x509Certificate), string2, string, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, CMSSignedDataGenerator.getSignerIdentifier(byArray), string2, string, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, attributeTable, attributeTable2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, CMSSignedDataGenerator.getSignerIdentifier(x509Certificate), string2, string, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, string, this.getEncOID(privateKey, string), (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, CMSSignedDataGenerator.getSignerIdentifier(byArray), string2, string, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, CMSSignedDataGenerator.getSignerIdentifier(x509Certificate), string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, string, this.getEncOID(privateKey, string), cMSAttributeTableGenerator, cMSAttributeTableGenerator2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, CMSSignedDataGenerator.getSignerIdentifier(byArray), string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, CMSUtils.getProvider(string));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(cMSProcessable, false, provider);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(string, cMSProcessable, bl, provider, true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2, boolean bl2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), bl2);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider, boolean bl2) throws NoSuchAlgorithmException, CMSException {
        ByteArrayOutputStream byteArrayOutputStream;
        SignerInf signerInf2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        this._digests.clear();
        for (SignerInformation signerInformation : this._signers) {
            aSN1EncodableVector.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(signerInformation.getDigestAlgorithmID()));
            aSN1EncodableVector2.add((DEREncodable)signerInformation.toSignerInfo());
        }
        boolean bl3 = string == null;
        DERObjectIdentifier dERObjectIdentifier = bl3 ? CMSObjectIdentifiers.data : new DERObjectIdentifier(string);
        for (SignerInf signerInf2 : this.signerInfs) {
            try {
                aSN1EncodableVector.add((DEREncodable)signerInf2.getDigestAlgorithmID());
                aSN1EncodableVector2.add((DEREncodable)signerInf2.toSignerInfo(dERObjectIdentifier, cMSProcessable, this.rand, provider, bl2, bl3));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for signature.", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("error creating signature.", signatureException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        signerInf2 = null;
        if (this._certs.size() != 0) {
            signerInf2 = CMSUtils.createBerSetFromList(this._certs);
        }
        ASN1Set aSN1Set = null;
        if (this._crls.size() != 0) {
            aSN1Set = CMSUtils.createBerSetFromList(this._crls);
        }
        BERConstructedOctetString bERConstructedOctetString = null;
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (cMSProcessable != null) {
                try {
                    cMSProcessable.write(byteArrayOutputStream);
                }
                catch (IOException iOException) {
                    throw new CMSException("encapsulation error.", iOException);
                }
            }
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
        }
        byteArrayOutputStream = new ContentInfo(dERObjectIdentifier, bERConstructedOctetString);
        SignedData signedData = new SignedData((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector), (ContentInfo)byteArrayOutputStream, (ASN1Set)signerInf2, aSN1Set, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector2));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)signedData);
        return new CMSSignedData(cMSProcessable, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, cMSProcessable, bl, string);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(DATA, cMSProcessable, bl, provider);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, provider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, CMSUtils.getProvider(string)).getSignerInfos();
    }

    private class SignerInf {
        private final PrivateKey key;
        private final SignerIdentifier signerIdentifier;
        private final String digestOID;
        private final String encOID;
        private final CMSAttributeTableGenerator sAttr;
        private final CMSAttributeTableGenerator unsAttr;
        private final AttributeTable baseSignedTable;

        SignerInf(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) {
            this.key = privateKey;
            this.signerIdentifier = signerIdentifier;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = cMSAttributeTableGenerator;
            this.unsAttr = cMSAttributeTableGenerator2;
            this.baseSignedTable = attributeTable;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), (DEREncodable)new DERNull());
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, SecureRandom secureRandom, Provider provider, boolean bl, boolean bl2) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            byte[] byArray;
            Object object;
            AttributeTable attributeTable;
            Map map;
            AlgorithmIdentifier algorithmIdentifier = this.getDigestAlgorithmID();
            String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String string2 = string + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string2, provider);
            MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string, provider);
            AlgorithmIdentifier algorithmIdentifier2 = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.encOID, signature);
            if (cMSProcessable != null) {
                cMSProcessable.write(new CMSSignedGenerator.DigOutputStream(messageDigest));
            }
            byte[] byArray2 = messageDigest.digest();
            CMSSignedDataGenerator.this._digests.put(this.digestOID, byArray2.clone());
            if (bl) {
                map = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray2);
                attributeTable = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(map)) : null;
            } else {
                attributeTable = this.baseSignedTable;
            }
            map = null;
            if (attributeTable != null) {
                if (bl2) {
                    object = attributeTable.toHashtable();
                    ((Hashtable)object).remove(CMSAttributes.contentType);
                    attributeTable = new AttributeTable((Hashtable)object);
                }
                map = CMSSignedDataGenerator.this.getAttributeSet(attributeTable);
                byArray = map.getEncoded("DER");
            } else {
                object = new ByteArrayOutputStream();
                if (cMSProcessable != null) {
                    cMSProcessable.write((OutputStream)object);
                }
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
            signature.initSign(this.key, secureRandom);
            signature.update(byArray);
            object = signature.sign();
            ASN1Set aSN1Set = null;
            if (this.unsAttr != null) {
                Map map2 = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray2);
                map2.put("encryptedDigest", object.clone());
                AttributeTable attributeTable2 = this.unsAttr.getAttributes(Collections.unmodifiableMap(map2));
                aSN1Set = CMSSignedDataGenerator.this.getAttributeSet(attributeTable2);
            }
            return new SignerInfo(this.signerIdentifier, algorithmIdentifier, (ASN1Set)map, algorithmIdentifier2, (ASN1OctetString)new DEROctetString((byte[])object), aSN1Set);
        }
    }
}

