/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.gpg.SXprUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class SExprParser {
    private final PGPDigestCalculatorProvider digestProvider;

    public SExprParser(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.digestProvider = pGPDigestCalculatorProvider;
    }

    public PGPSecretKey parseSecretKey(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, PGPPublicKey pGPPublicKey) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String string = SXprUtils.readString(inputStream, inputStream.read());
        if (string.equals("protected-private-key")) {
            SXprUtils.skipOpenParenthesis(inputStream);
            String string2 = SXprUtils.readString(inputStream, inputStream.read());
            if (string2.equals("ecc")) {
                SXprUtils.skipOpenParenthesis(inputStream);
                String string3 = SXprUtils.readString(inputStream, inputStream.read());
                String string4 = SXprUtils.readString(inputStream, inputStream.read());
                SXprUtils.skipCloseParenthesis(inputStream);
                SXprUtils.skipOpenParenthesis(inputStream);
                string = SXprUtils.readString(inputStream, inputStream.read());
                if (!string.equals("q")) {
                    throw new PGPException("no q value found");
                }
                byte[] byArray = SXprUtils.readBytes(inputStream, inputStream.read());
                SXprUtils.skipCloseParenthesis(inputStream);
                BigInteger bigInteger = this.processECSecretKey(inputStream, string3, string4, byArray, pBEProtectionRemoverFactory);
                if (string4.startsWith("NIST ")) {
                    string4 = string4.substring("NIST ".length());
                }
                ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey(ECNamedCurveTable.getOID((String)string4), new BigInteger(1, byArray));
                ECPublicBCPGKey eCPublicBCPGKey = (ECPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                if (!eCDSAPublicBCPGKey.getCurveOID().equals((Object)eCPublicBCPGKey.getCurveOID()) || !eCDSAPublicBCPGKey.getEncodedPoint().equals(eCPublicBCPGKey.getEncodedPoint())) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, null, null, new ECSecretBCPGKey(bigInteger).getEncoded()), pGPPublicKey);
            }
            if (string2.equals("dsa")) {
                BigInteger bigInteger = this.readBigInteger("p", inputStream);
                BigInteger bigInteger2 = this.readBigInteger("q", inputStream);
                BigInteger bigInteger3 = this.readBigInteger("g", inputStream);
                BigInteger bigInteger4 = this.readBigInteger("y", inputStream);
                BigInteger bigInteger5 = this.processDSASecretKey(inputStream, bigInteger, bigInteger2, bigInteger3, bigInteger4, pBEProtectionRemoverFactory);
                DSAPublicBCPGKey dSAPublicBCPGKey = new DSAPublicBCPGKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
                DSAPublicBCPGKey dSAPublicBCPGKey2 = (DSAPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                if (!(dSAPublicBCPGKey.getP().equals(dSAPublicBCPGKey2.getP()) && dSAPublicBCPGKey.getQ().equals(dSAPublicBCPGKey2.getQ()) && dSAPublicBCPGKey.getG().equals(dSAPublicBCPGKey2.getG()) && dSAPublicBCPGKey.getY().equals(dSAPublicBCPGKey2.getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, null, null, new DSASecretBCPGKey(bigInteger5).getEncoded()), pGPPublicKey);
            }
            if (string2.equals("elg")) {
                BigInteger bigInteger = this.readBigInteger("p", inputStream);
                BigInteger bigInteger6 = this.readBigInteger("g", inputStream);
                BigInteger bigInteger7 = this.readBigInteger("y", inputStream);
                BigInteger bigInteger8 = this.processElGamalSecretKey(inputStream, bigInteger, bigInteger6, bigInteger7, pBEProtectionRemoverFactory);
                ElGamalPublicBCPGKey elGamalPublicBCPGKey = new ElGamalPublicBCPGKey(bigInteger, bigInteger6, bigInteger7);
                ElGamalPublicBCPGKey elGamalPublicBCPGKey2 = (ElGamalPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                if (!(elGamalPublicBCPGKey.getP().equals(elGamalPublicBCPGKey2.getP()) && elGamalPublicBCPGKey.getG().equals(elGamalPublicBCPGKey2.getG()) && elGamalPublicBCPGKey.getY().equals(elGamalPublicBCPGKey2.getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, null, null, new ElGamalSecretBCPGKey(bigInteger8).getEncoded()), pGPPublicKey);
            }
            if (string2.equals("rsa")) {
                BigInteger bigInteger = this.readBigInteger("n", inputStream);
                BigInteger bigInteger9 = this.readBigInteger("e", inputStream);
                BigInteger[] bigIntegerArray = this.processRSASecretKey(inputStream, bigInteger, bigInteger9, pBEProtectionRemoverFactory);
                RSAPublicBCPGKey rSAPublicBCPGKey = new RSAPublicBCPGKey(bigInteger, bigInteger9);
                RSAPublicBCPGKey rSAPublicBCPGKey2 = (RSAPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                if (!rSAPublicBCPGKey.getModulus().equals(rSAPublicBCPGKey2.getModulus()) || !rSAPublicBCPGKey.getPublicExponent().equals(rSAPublicBCPGKey2.getPublicExponent())) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, null, null, new RSASecretBCPGKey(bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2]).getEncoded()), pGPPublicKey);
            }
            throw new PGPException("unknown key type: " + string2);
        }
        throw new PGPException("unknown key type found");
    }

    public PGPSecretKey parseSecretKey(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String string = SXprUtils.readString(inputStream, inputStream.read());
        if (string.equals("protected-private-key")) {
            SXprUtils.skipOpenParenthesis(inputStream);
            String string2 = SXprUtils.readString(inputStream, inputStream.read());
            if (string2.equals("ecc")) {
                SXprUtils.skipOpenParenthesis(inputStream);
                String string3 = SXprUtils.readString(inputStream, inputStream.read());
                String string4 = SXprUtils.readString(inputStream, inputStream.read());
                if (string4.startsWith("NIST ")) {
                    string4 = string4.substring("NIST ".length());
                }
                SXprUtils.skipCloseParenthesis(inputStream);
                SXprUtils.skipOpenParenthesis(inputStream);
                string = SXprUtils.readString(inputStream, inputStream.read());
                if (!string.equals("q")) {
                    throw new PGPException("no q value found");
                }
                byte[] byArray = SXprUtils.readBytes(inputStream, inputStream.read());
                PublicKeyPacket publicKeyPacket = new PublicKeyPacket(19, new Date(), new ECDSAPublicBCPGKey(ECNamedCurveTable.getOID((String)string4), new BigInteger(1, byArray)));
                SXprUtils.skipCloseParenthesis(inputStream);
                BigInteger bigInteger = this.processECSecretKey(inputStream, string3, string4, byArray, pBEProtectionRemoverFactory);
                return new PGPSecretKey(new SecretKeyPacket(publicKeyPacket, 0, null, null, new ECSecretBCPGKey(bigInteger).getEncoded()), new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator));
            }
            if (string2.equals("dsa")) {
                BigInteger bigInteger = this.readBigInteger("p", inputStream);
                BigInteger bigInteger2 = this.readBigInteger("q", inputStream);
                BigInteger bigInteger3 = this.readBigInteger("g", inputStream);
                BigInteger bigInteger4 = this.readBigInteger("y", inputStream);
                BigInteger bigInteger5 = this.processDSASecretKey(inputStream, bigInteger, bigInteger2, bigInteger3, bigInteger4, pBEProtectionRemoverFactory);
                PublicKeyPacket publicKeyPacket = new PublicKeyPacket(17, new Date(), new DSAPublicBCPGKey(bigInteger, bigInteger2, bigInteger3, bigInteger4));
                return new PGPSecretKey(new SecretKeyPacket(publicKeyPacket, 0, null, null, new DSASecretBCPGKey(bigInteger5).getEncoded()), new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator));
            }
            if (string2.equals("elg")) {
                BigInteger bigInteger = this.readBigInteger("p", inputStream);
                BigInteger bigInteger6 = this.readBigInteger("g", inputStream);
                BigInteger bigInteger7 = this.readBigInteger("y", inputStream);
                BigInteger bigInteger8 = this.processElGamalSecretKey(inputStream, bigInteger, bigInteger6, bigInteger7, pBEProtectionRemoverFactory);
                PublicKeyPacket publicKeyPacket = new PublicKeyPacket(16, new Date(), new ElGamalPublicBCPGKey(bigInteger, bigInteger6, bigInteger7));
                return new PGPSecretKey(new SecretKeyPacket(publicKeyPacket, 0, null, null, new ElGamalSecretBCPGKey(bigInteger8).getEncoded()), new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator));
            }
            if (string2.equals("rsa")) {
                BigInteger bigInteger = this.readBigInteger("n", inputStream);
                BigInteger bigInteger9 = this.readBigInteger("e", inputStream);
                BigInteger[] bigIntegerArray = this.processRSASecretKey(inputStream, bigInteger, bigInteger9, pBEProtectionRemoverFactory);
                PublicKeyPacket publicKeyPacket = new PublicKeyPacket(1, new Date(), new RSAPublicBCPGKey(bigInteger, bigInteger9));
                return new PGPSecretKey(new SecretKeyPacket(publicKeyPacket, 0, null, null, new RSASecretBCPGKey(bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2]).getEncoded()), new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator));
            }
            throw new PGPException("unknown key type: " + string2);
        }
        throw new PGPException("unknown key type found");
    }

    private BigInteger readBigInteger(String string, InputStream inputStream) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String string2 = SXprUtils.readString(inputStream, inputStream.read());
        if (!string2.equals(string)) {
            throw new PGPException(string + " value expected");
        }
        byte[] byArray = SXprUtils.readBytes(inputStream, inputStream.read());
        BigInteger bigInteger = new BigInteger(1, byArray);
        SXprUtils.skipCloseParenthesis(inputStream);
        return bigInteger;
    }

    private static byte[][] extractData(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws PGPException, IOException {
        byte[] byArray;
        byte[] byArray2 = null;
        SXprUtils.skipOpenParenthesis(inputStream);
        String string = SXprUtils.readString(inputStream, inputStream.read());
        if (string.equals("protected")) {
            String string2 = SXprUtils.readString(inputStream, inputStream.read());
            SXprUtils.skipOpenParenthesis(inputStream);
            S2K s2K = SXprUtils.parseS2K(inputStream);
            byte[] byArray3 = SXprUtils.readBytes(inputStream, inputStream.read());
            SXprUtils.skipCloseParenthesis(inputStream);
            byte[] byArray4 = SXprUtils.readBytes(inputStream, inputStream.read());
            SXprUtils.skipCloseParenthesis(inputStream);
            PBESecretKeyDecryptor pBESecretKeyDecryptor = pBEProtectionRemoverFactory.createDecryptor(string2);
            byte[] byArray5 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(7, s2K);
            byArray = pBESecretKeyDecryptor.recoverKeyData(7, byArray5, byArray3, byArray4, 0, byArray4.length);
            if (inputStream.read() == 40) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(40);
                while ((n = inputStream.read()) >= 0 && n != 41) {
                    byteArrayOutputStream.write(n);
                }
                if (n != 41) {
                    throw new IOException("unexpected end to SExpr");
                }
                byteArrayOutputStream.write(41);
                byArray2 = byteArrayOutputStream.toByteArray();
            }
        } else {
            throw new PGPException("protected block not found");
        }
        SXprUtils.skipCloseParenthesis(inputStream);
        SXprUtils.skipCloseParenthesis(inputStream);
        return new byte[][]{byArray, byArray2};
    }

    private BigInteger processDSASecretKey(InputStream inputStream, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] byArray = SExprParser.extractData(inputStream, pBEProtectionRemoverFactory);
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        BigInteger bigInteger5 = this.readBigInteger("x", byteArrayInputStream);
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        String string = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        string = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] byArray4 = SXprUtils.readBytes(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        if (this.digestProvider != null) {
            PGPDigestCalculator pGPDigestCalculator = this.digestProvider.get(2);
            OutputStream outputStream = pGPDigestCalculator.getOutputStream();
            outputStream.write(Strings.toByteArray((String)"(3:dsa"));
            this.writeCanonical(outputStream, "p", bigInteger);
            this.writeCanonical(outputStream, "q", bigInteger2);
            this.writeCanonical(outputStream, "g", bigInteger3);
            this.writeCanonical(outputStream, "y", bigInteger4);
            this.writeCanonical(outputStream, "x", bigInteger5);
            if (byArray3 != null) {
                outputStream.write(byArray3);
            }
            outputStream.write(Strings.toByteArray((String)")"));
            byte[] byArray5 = pGPDigestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])byArray5, (byte[])byArray4)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return bigInteger5;
    }

    private BigInteger processElGamalSecretKey(InputStream inputStream, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] byArray = SExprParser.extractData(inputStream, pBEProtectionRemoverFactory);
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        BigInteger bigInteger4 = this.readBigInteger("x", byteArrayInputStream);
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        String string = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        string = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] byArray4 = SXprUtils.readBytes(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        if (this.digestProvider != null) {
            PGPDigestCalculator pGPDigestCalculator = this.digestProvider.get(2);
            OutputStream outputStream = pGPDigestCalculator.getOutputStream();
            outputStream.write(Strings.toByteArray((String)"(3:elg"));
            this.writeCanonical(outputStream, "p", bigInteger);
            this.writeCanonical(outputStream, "g", bigInteger2);
            this.writeCanonical(outputStream, "y", bigInteger3);
            this.writeCanonical(outputStream, "x", bigInteger4);
            if (byArray3 != null) {
                outputStream.write(byArray3);
            }
            outputStream.write(Strings.toByteArray((String)")"));
            byte[] byArray5 = pGPDigestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])byArray5, (byte[])byArray4)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return bigInteger4;
    }

    private BigInteger processECSecretKey(InputStream inputStream, String string, String string2, byte[] byArray, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] byArray2 = SExprParser.extractData(inputStream, pBEProtectionRemoverFactory);
        byte[] byArray3 = byArray2[0];
        byte[] byArray4 = byArray2[1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        BigInteger bigInteger = this.readBigInteger("d", byteArrayInputStream);
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        String string3 = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string3.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        string3 = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string3.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] byArray5 = SXprUtils.readBytes(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        if (this.digestProvider != null) {
            PGPDigestCalculator pGPDigestCalculator = this.digestProvider.get(2);
            OutputStream outputStream = pGPDigestCalculator.getOutputStream();
            outputStream.write(Strings.toByteArray((String)"(3:ecc"));
            outputStream.write(Strings.toByteArray((String)("(" + string.length() + ":" + string + string2.length() + ":" + string2 + ")")));
            this.writeCanonical(outputStream, "q", byArray);
            this.writeCanonical(outputStream, "d", bigInteger);
            if (byArray4 != null) {
                outputStream.write(byArray4);
            }
            outputStream.write(Strings.toByteArray((String)")"));
            byte[] byArray6 = pGPDigestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])byArray6, (byte[])byArray5)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return bigInteger;
    }

    private BigInteger[] processRSASecretKey(InputStream inputStream, BigInteger bigInteger, BigInteger bigInteger2, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] byArray = SExprParser.extractData(inputStream, pBEProtectionRemoverFactory);
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        BigInteger bigInteger3 = this.readBigInteger("d", byteArrayInputStream);
        BigInteger bigInteger4 = this.readBigInteger("p", byteArrayInputStream);
        BigInteger bigInteger5 = this.readBigInteger("q", byteArrayInputStream);
        BigInteger bigInteger6 = this.readBigInteger("u", byteArrayInputStream);
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        SXprUtils.skipOpenParenthesis(byteArrayInputStream);
        String string = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        string = SXprUtils.readString(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        if (!string.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] byArray4 = SXprUtils.readBytes(byteArrayInputStream, ((InputStream)byteArrayInputStream).read());
        SXprUtils.skipCloseParenthesis(byteArrayInputStream);
        if (this.digestProvider != null) {
            PGPDigestCalculator pGPDigestCalculator = this.digestProvider.get(2);
            OutputStream outputStream = pGPDigestCalculator.getOutputStream();
            outputStream.write(Strings.toByteArray((String)"(3:rsa"));
            this.writeCanonical(outputStream, "n", bigInteger);
            this.writeCanonical(outputStream, "e", bigInteger2);
            this.writeCanonical(outputStream, "d", bigInteger3);
            this.writeCanonical(outputStream, "p", bigInteger4);
            this.writeCanonical(outputStream, "q", bigInteger5);
            this.writeCanonical(outputStream, "u", bigInteger6);
            if (byArray3 != null) {
                outputStream.write(byArray3);
            }
            outputStream.write(Strings.toByteArray((String)")"));
            byte[] byArray5 = pGPDigestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])byArray5, (byte[])byArray4)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return new BigInteger[]{bigInteger3, bigInteger4, bigInteger5, bigInteger6};
    }

    private void writeCanonical(OutputStream outputStream, String string, BigInteger bigInteger) throws IOException {
        this.writeCanonical(outputStream, string, bigInteger.toByteArray());
    }

    private void writeCanonical(OutputStream outputStream, String string, byte[] byArray) throws IOException {
        outputStream.write(Strings.toByteArray((String)("(" + string.length() + ":" + string + byArray.length + ":")));
        outputStream.write(byArray);
        outputStream.write(Strings.toByteArray((String)")"));
    }
}

