/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.crypto.NativeFeatures;
import org.bouncycastle.crypto.NativeLibIdentity;
import org.bouncycastle.crypto.NativeLoader;
import org.bouncycastle.crypto.NativeServices;
import org.bouncycastle.crypto.VariantSelector;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DefaultNativeServices
implements NativeServices {
    private static Set<String> nativeFeatures = null;

    DefaultNativeServices() {
    }

    @Override
    public String getStatusMessage() {
        if (NativeLoader.isNativeLibsAvailableForSystem()) {
            if (NativeLoader.isNativeInstalled()) {
                return "READY";
            }
            return NativeLoader.getNativeStatusMessage();
        }
        return "UNSUPPORTED";
    }

    @Override
    public Set<String> getFeatureSet() {
        return DefaultNativeServices.getNativeFeatureSet();
    }

    @Override
    public String getVariant() {
        return NativeLoader.getSelectedVariant();
    }

    @Override
    public String[][] getVariantSelectionMatrix() {
        return VariantSelector.getFeatureMatrix();
    }

    @Override
    public boolean hasService(String string) {
        if (nativeFeatures == null) {
            nativeFeatures = NativeLoader.isJavaSupportOnly() ? Collections.singleton("NONE") : DefaultNativeServices.getNativeFeatureSet();
        }
        return nativeFeatures.contains(string);
    }

    @Override
    public String getBuildDate() {
        return NativeLibIdentity.getNativeBuiltTimeStamp();
    }

    @Override
    public String getLibraryIdent() {
        return NativeLibIdentity.getLibraryIdent();
    }

    @Override
    public boolean isEnabled() {
        return NativeLoader.isNativeAvailable();
    }

    @Override
    public boolean isInstalled() {
        return NativeLoader.isNativeInstalled();
    }

    @Override
    public boolean isSupported() {
        return NativeLoader.isNativeLibsAvailableForSystem();
    }

    static Set<String> getNativeFeatureSet() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!NativeLoader.isJavaSupportOnly()) {
            if (NativeFeatures.hasHardwareSeed()) {
                treeSet.add("NRBG");
            }
            if (NativeFeatures.hasHardwareRand()) {
                treeSet.add("DRBG");
            }
            if (NativeFeatures.hasAESHardwareSupport()) {
                treeSet.add("AES/ECB");
            }
            if (NativeFeatures.hasGCMHardwareSupport()) {
                treeSet.add("AES/GCM");
            }
            if (NativeFeatures.hasGCMSIVHardwareSupport()) {
                treeSet.add("AES/GCM-SIV");
            }
            if (NativeFeatures.hasCBCHardwareSupport()) {
                treeSet.add("AES/CBC");
            }
            if (NativeFeatures.hasCFBHardwareSupport()) {
                treeSet.add("AES/CFB");
            }
            if (NativeFeatures.hasCTRHardwareSupport()) {
                treeSet.add("AES/CTR");
            }
            if (NativeFeatures.hasHardwareSHA256()) {
                treeSet.add("SHA2");
                treeSet.add("SHA256");
            }
            if (NativeFeatures.hasHardwareSHA224()) {
                treeSet.add("SHA224");
            }
            if (NativeFeatures.hasHardwareSHA384()) {
                treeSet.add("SHA384");
            }
            if (NativeFeatures.hasHardwareSHA512()) {
                treeSet.add("SHA512");
            }
            if (NativeFeatures.hasHardwareSHA512()) {
                treeSet.add("SHA512");
            }
            if (NativeFeatures.hasCCMHardwareSupport()) {
                treeSet.add("AES/CCM");
            }
            if (NativeFeatures.hasCBCPCHardwareSupport()) {
                treeSet.add("AES/CBC-PC");
            }
            if (NativeFeatures.hasCCMPCHardwareSupport()) {
                treeSet.add("AES/CCM-PC");
            }
            if (NativeFeatures.hasCFBPCHardwareSupport()) {
                treeSet.add("AES/CFB-PC");
            }
            if (NativeFeatures.hasCTRPCHardwareSupport()) {
                treeSet.add("AES/CTR-PC");
            }
            if (NativeFeatures.hasGCMPCHardwareSupport()) {
                treeSet.add("AES/GCM-PC");
            }
            if (NativeFeatures.hasGCMSIVPCHardwareSupport()) {
                treeSet.add("AES/GCMSIV-PC");
            }
            if (NativeFeatures.hasMultiplyAcc()) {
                treeSet.add("MULACC");
            }
            if (NativeFeatures.hasSHA3()) {
                treeSet.add("SHA3");
            }
            if (NativeFeatures.hasSHAKE()) {
                treeSet.add("SHAKE");
            }
        }
        if (treeSet.isEmpty()) {
            treeSet.add("NONE");
        }
        return Collections.unmodifiableSet(treeSet);
    }
}

