/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHGroupVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.CertificateStatusRequestItemV2;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provClientEnableCA = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableCAExtension", false);
    private static final boolean provClientEnableSessionResumption = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableSessionResumption", true);
    private static final boolean provClientEnableStatusRequest = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableStatusRequestExtension", true);
    private static final boolean provClientEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableTrustedCAKeysExtension", false);
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager, ProvSSLParameters sslParameters) {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = sslParameters.copyForConnection();
    }

    @Override
    protected Vector<X500Name> getCertificateAuthorities() {
        if (provClientEnableCA) {
            return JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager());
        }
        return null;
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest ocspStatusRequest = new OCSPStatusRequest(null, null);
        return new CertificateStatusRequest(1, ocspStatusRequest);
    }

    @Override
    protected Vector<CertificateStatusRequestItemV2> getMultiCertStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest ocspStatusRequest = new OCSPStatusRequest(null, null);
        Vector<CertificateStatusRequestItemV2> result = new Vector<CertificateStatusRequestItemV2>(2);
        result.add(new CertificateStatusRequestItemV2(2, ocspStatusRequest));
        result.add(new CertificateStatusRequestItemV2(1, ocspStatusRequest));
        return result;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected Vector<Integer> getSupportedGroups(Vector namedGroupRolesRaw) {
        return NamedGroupInfo.getSupportedGroupsLocalClient(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    protected Vector<ServerName> getSNIServerNames() {
        if (provEnableSNIExtension) {
            String peerHostSNI;
            List<BCSNIServerName> sniServerNames = this.sslParameters.getServerNames();
            if (null == sniServerNames && null != (peerHostSNI = this.manager.getPeerHostSNI()) && peerHostSNI.indexOf(46) > 0 && !IPAddress.isValid((String)peerHostSNI)) {
                try {
                    sniServerNames = Collections.singletonList(new BCSNIHostName(peerHostSNI));
                }
                catch (RuntimeException e) {
                    LOG.fine("Failed to add peer host as default SNI host_name: " + peerHostSNI);
                }
            }
            if (null != sniServerNames && !sniServerNames.isEmpty()) {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    serverNames.add(new ServerName((short)sniServerName.getType(), sniServerName.getEncoded()));
                }
                return serverNames;
            }
        }
        return null;
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion[] activeProtocolVersions = this.getProtocolVersions();
        List<SignatureSchemeInfo> signatureSchemes = contextData.getActiveCertsSignatureSchemes(false, this.sslParameters, activeProtocolVersions, this.jsseSecurityParameters.namedGroups);
        this.jsseSecurityParameters.localSigSchemes = signatureSchemes;
        this.jsseSecurityParameters.localSigSchemesCert = signatureSchemes;
        return SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.jsseSecurityParameters.localSigSchemes);
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithmsCert() {
        return null;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected Vector<TrustedAuthority> getTrustedCAIndication() {
        Vector<X500Name> certificateAuthorities;
        if (provClientEnableTrustedCAKeys && null != (certificateAuthorities = JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager()))) {
            Vector<TrustedAuthority> trustedCAKeys = new Vector<TrustedAuthority>(certificateAuthorities.size());
            for (X500Name certificateAuthority : certificateAuthorities) {
                trustedCAKeys.add(new TrustedAuthority(2, certificateAuthority));
            }
            return trustedCAKeys;
        }
        return null;
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new ProvDHGroupVerifier();
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                ContextData contextData = ProvTlsClient.this.manager.getContextData();
                SecurityParameters securityParameters = ProvTlsClient.this.context.getSecurityParametersHandshake();
                ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
                boolean isTLSv13 = TlsUtils.isTLSv13(negotiatedVersion);
                Vector serverSigAlgs = securityParameters.getServerSigAlgs();
                Vector serverSigAlgsCert = securityParameters.getServerSigAlgsCert();
                ProvTlsClient.this.jsseSecurityParameters.peerSigSchemes = contextData.getSignatureSchemes(serverSigAlgs);
                List<SignatureSchemeInfo> list = ProvTlsClient.this.jsseSecurityParameters.peerSigSchemesCert = serverSigAlgs == serverSigAlgsCert ? ProvTlsClient.this.jsseSecurityParameters.peerSigSchemes : contextData.getSignatureSchemes(serverSigAlgsCert);
                if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
                    return null;
                }
                Principal[] issuers = JsseUtils.toX500Principals(certificateRequest.getCertificateAuthorities());
                byte[] certificateRequestContext = certificateRequest.getCertificateRequestContext();
                if (isTLSv13 != (null != certificateRequestContext)) {
                    throw new TlsFatalAlert(80);
                }
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (isTLSv13 != (null == certificateTypes)) {
                    throw new TlsFatalAlert(80);
                }
                if (isTLSv13) {
                    return ProvTlsClient.this.selectClientCredentials13(issuers, certificateRequestContext);
                }
                if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(negotiatedVersion)) {
                    return ProvTlsClient.this.selectClientCredentials12(issuers, certificateTypes);
                }
                return ProvTlsClient.this.selectClientCredentialsLegacy(issuers, certificateTypes);
            }

            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                if (null == serverCertificate || null == serverCertificate.getCertificate() || serverCertificate.getCertificate().isEmpty()) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(ProvTlsClient.this.getCrypto(), serverCertificate.getCertificate());
                String authType = JsseUtils.getAuthTypeServer(ProvTlsClient.this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm());
                ProvTlsClient.this.jsseSecurityParameters.statusResponses = JsseUtils.getStatusResponses(serverCertificate.getCertificateStatus());
                ProvTlsClient.this.manager.checkServerTrusted(chain, authType);
            }
        };
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public int getMaxCertificateChainLength() {
        return JsseUtils.getMaxCertificateChainLength();
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return JsseUtils.getMaxHandshakeMessageSize();
    }

    @Override
    public TlsSession getSessionToResume() {
        if (provClientEnableSessionResumption) {
            TlsSession sessionToResume;
            SessionParameters resumableSessionParameters;
            ProvSSLSession availableSSLSession = this.sslParameters.getSessionToResume();
            if (null == availableSSLSession) {
                ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
                availableSSLSession = sslSessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
            }
            if (null != availableSSLSession && null != (resumableSessionParameters = this.getResumableSessionParameters(availableSSLSession, sessionToResume = availableSSLSession.getTlsSession()))) {
                this.sslSession = availableSSLSession;
                if (!this.manager.getEnableSessionCreation()) {
                    this.cipherSuites = new int[]{resumableSessionParameters.getCipherSuite()};
                }
                return sessionToResume;
            }
        }
        JsseUtils.checkSessionCreationEnabled(this.manager);
        return null;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client raised", alertLevel, alertDescription);
            if (message != null) {
                msg = msg + ": " + message;
            }
            LOG.log(level, msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client received", alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion[] activeProtocolVersions = this.getProtocolVersions();
        this.jsseSecurityParameters.namedGroups = contextData.getNamedGroups(this.sslParameters, activeProtocolVersions);
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession connectionTlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != connectionTlsSession) {
            ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
            String peerHost = this.manager.getPeerHost();
            int peerPort = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm(), null);
            boolean addToCache = provClientEnableSessionResumption && !TlsUtils.isTLSv13(this.context);
            this.sslSession = sslSessionContext.reportSession(peerHost, peerPort, connectionTlsSession, jsseSessionParameters, addToCache);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        String selectedCipherSuiteName = this.manager.getContextData().getContext().validateNegotiatedCipherSuite(this.sslParameters, selectedCipherSuite);
        LOG.fine("Client notified of selected cipher suite: " + selectedCipherSuiteName);
        super.notifySelectedCipherSuite(selectedCipherSuite);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String serverVersionName = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, serverVersion);
        LOG.fine("Client notified of selected protocol version: " + serverVersionName);
        super.notifyServerVersion(serverVersion);
    }

    @Override
    public void notifySessionToResume(TlsSession session) {
        if (null == session) {
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        super.notifySessionToResume(session);
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        boolean isResumed;
        boolean bl = isResumed = !TlsUtils.isNullOrEmpty(sessionID) && null != this.sslSession && Arrays.areEqual((byte[])sessionID, (byte[])this.sslSession.getId());
        if (isResumed) {
            LOG.fine("Server resumed session: " + Hex.toHexString((byte[])sessionID));
        } else {
            this.sslSession = null;
            if (TlsUtils.isNullOrEmpty(sessionID)) {
                LOG.fine("Server did not specify a session ID");
            } else {
                LOG.fine("Server specified new session: " + Hex.toHexString((byte[])sessionID));
            }
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        this.manager.notifyHandshakeSession(this.manager.getContextData().getClientSessionContext(), this.context.getSecurityParametersHandshake(), this.jsseSecurityParameters, this.sslSession);
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        super.processServerExtensions(serverExtensions);
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        if (null != securityParameters.getClientServerNames()) {
            boolean sniAccepted = TlsExtensionsUtils.hasServerNameExtensionServer(serverExtensions);
            LOG.finer("Server accepted SNI?: " + sniAccepted);
        }
    }

    @Override
    public boolean requiresCloseNotify() {
        return JsseUtils.requireCloseNotify();
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected String[] getKeyTypesLegacy(short[] certificateTypes) throws IOException {
        String[] keyTypes = new String[certificateTypes.length];
        for (int i = 0; i < certificateTypes.length; ++i) {
            keyTypes[i] = JsseUtils.getKeyTypeLegacyClient(certificateTypes[i]);
        }
        return keyTypes;
    }

    protected SessionParameters getResumableSessionParameters(ProvSSLSession provSSLSession, TlsSession tlsSession) {
        JsseSessionParameters jsseSessionParameters;
        String sessionEndpointID;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return null;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (null == sessionParameters || !ProtocolVersion.contains(this.getProtocolVersions(), sessionParameters.getNegotiatedVersion()) || !Arrays.contains((int[])this.getCipherSuites(), (int)sessionParameters.getCipherSuite())) {
            return null;
        }
        if (TlsUtils.isTLSv13(sessionParameters.getNegotiatedVersion())) {
            return null;
        }
        String connectionEndpointID = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != connectionEndpointID && !connectionEndpointID.equalsIgnoreCase(sessionEndpointID = (jsseSessionParameters = provSSLSession.getJsseSessionParameters()).getEndpointIDAlgorithm())) {
            LOG.finer("Session not resumable - endpoint ID algorithm mismatch; connection: " + connectionEndpointID + ", session: " + sessionEndpointID);
            return null;
        }
        return sessionParameters;
    }

    protected TlsCredentials selectClientCredentials12(Principal[] issuers, short[] certificateTypes) throws IOException {
        HashSet<String> keyManagerMissCache = new HashSet<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            short signatureAlgorithm;
            short certificateType;
            String keyType = JsseUtils.getKeyType(signatureSchemeInfo);
            if (keyManagerMissCache.contains(keyType) || (certificateType = SignatureAlgorithm.getClientCertificateType(signatureAlgorithm = signatureSchemeInfo.getSignatureAlgorithm())) < 0 || !Arrays.contains((short[])certificateTypes, (short)certificateType) || !this.jsseSecurityParameters.localSigSchemes.contains(signatureSchemeInfo)) continue;
            BCX509Key x509Key = this.manager.chooseClientKey(new String[]{keyType}, issuers);
            if (null == x509Key) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Client (1.2) found no credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + keyType + "')");
                }
                keyManagerMissCache.add(keyType);
                continue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Client (1.2) selected credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + keyType + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(x509Key.getPrivateKey()) + "'");
            }
            return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), x509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm());
        }
        LOG.fine("Client (1.2) did not select any credentials");
        return null;
    }

    protected TlsCredentials selectClientCredentials13(Principal[] issuers, byte[] certificateRequestContext) throws IOException {
        HashSet<String> keyManagerMissCache = new HashSet<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            String keyType;
            if (!signatureSchemeInfo.isSupportedPost13() || !this.jsseSecurityParameters.localSigSchemes.contains(signatureSchemeInfo) || keyManagerMissCache.contains(keyType = JsseUtils.getKeyType(signatureSchemeInfo))) continue;
            BCX509Key x509Key = this.manager.chooseClientKey(new String[]{keyType}, issuers);
            if (null == x509Key) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Client (1.3) found no credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + keyType + "')");
                }
                keyManagerMissCache.add(keyType);
                continue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Client (1.3) selected credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + keyType + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(x509Key.getPrivateKey()) + "'");
            }
            return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), x509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm(), certificateRequestContext);
        }
        LOG.fine("Client (1.3) did not select any credentials");
        return null;
    }

    protected TlsCredentials selectClientCredentialsLegacy(Principal[] issuers, short[] certificateTypes) throws IOException {
        String[] keyTypes = this.getKeyTypesLegacy(certificateTypes);
        BCX509Key x509Key = this.manager.chooseClientKey(keyTypes, issuers);
        if (null == x509Key) {
            return null;
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), x509Key, null);
    }
}

