/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsRSAUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsPSKKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsPSKIdentity pskIdentity;
    protected TlsPSKIdentityManager pskIdentityManager;
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected byte[] psk_identity_hint = null;
    protected byte[] psk = null;
    protected TlsDHConfig dhConfig;
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsPSKKeyExchange(int keyExchange, TlsPSKIdentity pskIdentity, TlsDHGroupVerifier dhGroupVerifier) {
        this(keyExchange, pskIdentity, null, dhGroupVerifier, null, null);
    }

    public TlsPSKKeyExchange(int keyExchange, TlsPSKIdentityManager pskIdentityManager, TlsDHConfig dhConfig, TlsECConfig ecConfig) {
        this(keyExchange, null, pskIdentityManager, null, dhConfig, ecConfig);
    }

    private TlsPSKKeyExchange(int keyExchange, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, TlsDHGroupVerifier dhGroupVerifier, TlsDHConfig dhConfig, TlsECConfig ecConfig) {
        super(TlsPSKKeyExchange.checkKeyExchange(keyExchange));
        this.pskIdentity = pskIdentity;
        this.pskIdentityManager = pskIdentityManager;
        this.dhGroupVerifier = dhGroupVerifier;
        this.dhConfig = dhConfig;
        this.ecConfig = ecConfig;
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange == 15) {
            throw new TlsFatalAlert(80);
        }
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = TlsUtils.requireDecryptorCredentials(serverCredentials);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(10);
        }
        this.serverCertificate = serverCertificate.getCertificateAt(0).checkUsageInRole(0, 3);
    }

    public byte[] generateServerKeyExchange() throws IOException {
        this.psk_identity_hint = this.pskIdentityManager.getHint();
        if (this.psk_identity_hint == null && !this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (this.psk_identity_hint == null) {
            TlsUtils.writeOpaque16(TlsUtils.EMPTY_BYTES, buf);
        } else {
            TlsUtils.writeOpaque16(this.psk_identity_hint, buf);
        }
        if (this.keyExchange == 14) {
            if (this.dhConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsDHUtils.writeDHConfig(this.dhConfig, buf);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.generateEphemeralDH(buf);
        } else if (this.keyExchange == 24) {
            if (this.ecConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsECCUtils.writeECConfig(this.ecConfig, buf);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.generateEphemeralECDH(buf);
        }
        return buf.toByteArray();
    }

    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 14: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(input);
        if (this.keyExchange == 14) {
            this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, input);
            byte[] y = TlsUtils.readOpaque16(input, 1);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.processEphemeralDH(y);
        } else if (this.keyExchange == 24) {
            this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, input);
            byte[] point = TlsUtils.readOpaque8(input, 1);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.processEphemeralECDH(point);
        }
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.psk_identity_hint == null) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] psk_identity = this.pskIdentity.getPSKIdentity();
        if (psk_identity == null) {
            throw new TlsFatalAlert(80);
        }
        this.psk = this.pskIdentity.getPSK();
        if (this.psk == null) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeOpaque16(psk_identity, output);
        this.context.getSecurityParametersHandshake().pskIdentity = Arrays.clone((byte[])psk_identity);
        if (this.keyExchange == 14) {
            this.generateEphemeralDH(output);
        } else if (this.keyExchange == 24) {
            this.generateEphemeralECDH(output);
        } else if (this.keyExchange == 15) {
            this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, output);
        }
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] psk_identity = TlsUtils.readOpaque16(input);
        this.psk = this.pskIdentityManager.getPSK(psk_identity);
        if (this.psk == null) {
            throw new TlsFatalAlert(115);
        }
        this.context.getSecurityParametersHandshake().pskIdentity = psk_identity;
        if (this.keyExchange == 14) {
            byte[] y = TlsUtils.readOpaque16(input, 1);
            this.processEphemeralDH(y);
        } else if (this.keyExchange == 24) {
            byte[] point = TlsUtils.readOpaque8(input, 1);
            this.processEphemeralECDH(point);
        } else if (this.keyExchange == 15) {
            byte[] encryptedPreMasterSecret = TlsUtils.readEncryptedPMS(this.context, input);
            this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
        }
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        byte[] other_secret = this.generateOtherSecret(this.psk.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4 + other_secret.length + this.psk.length);
        TlsUtils.writeOpaque16(other_secret, buf);
        TlsUtils.writeOpaque16(this.psk, buf);
        Arrays.fill((byte[])this.psk, (byte)0);
        this.psk = null;
        return this.context.getCrypto().createSecret(buf.toByteArray());
    }

    protected void generateEphemeralDH(OutputStream output) throws IOException {
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, output);
    }

    protected void generateEphemeralECDH(OutputStream output) throws IOException {
        byte[] point = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(point, output);
    }

    protected byte[] generateOtherSecret(int pskLength) throws IOException {
        if (this.keyExchange == 13) {
            return new byte[pskLength];
        }
        if ((this.keyExchange == 14 || this.keyExchange == 24) && this.agreement != null) {
            return this.agreement.calculateSecret().extract();
        }
        if (this.keyExchange == 15 && this.preMasterSecret != null) {
            return this.preMasterSecret.extract();
        }
        throw new TlsFatalAlert(80);
    }

    protected void processEphemeralDH(byte[] y) throws IOException {
        this.agreement.receivePeerValue(y);
    }

    protected void processEphemeralECDH(byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }
}

