/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509Key
implements BCX509Key {
    private static final Logger LOG = Logger.getLogger(ProvX509Key.class.getName());
    private final String keyType;
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    static ProvX509Key from(X509KeyManager x509KeyManager, String keyType, String alias) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == keyType || null == alias) {
            return null;
        }
        X509Certificate[] certificateChain = ProvX509Key.getCertificateChain(x509KeyManager, alias);
        if (null == certificateChain) {
            return null;
        }
        PrivateKey privateKey = ProvX509Key.getPrivateKey(x509KeyManager, alias);
        if (null == privateKey) {
            return null;
        }
        return new ProvX509Key(keyType, privateKey, certificateChain);
    }

    static ProvX509Key validate(X509KeyManager x509KeyManager, boolean forServer, String keyType, String alias, TransportData transportData) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == keyType || null == alias) {
            return null;
        }
        X509Certificate[] certificateChain = ProvX509Key.getCertificateChain(x509KeyManager, alias);
        if (null == certificateChain) {
            return null;
        }
        if (!ProvX509KeyManager.isSuitableKeyType(forServer, keyType, certificateChain[0], transportData)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Rejecting alias '" + alias + "': not suitable for key type '" + keyType + "'");
            }
            return null;
        }
        PrivateKey privateKey = ProvX509Key.getPrivateKey(x509KeyManager, alias);
        if (null == privateKey) {
            return null;
        }
        return new ProvX509Key(keyType, privateKey, certificateChain);
    }

    private static X509Certificate[] getCertificateChain(X509KeyManager x509KeyManager, String alias) {
        Object[] certificateChain = x509KeyManager.getCertificateChain(alias);
        if (TlsUtils.isNullOrEmpty(certificateChain)) {
            LOG.finer("Rejecting alias '" + alias + "': no certificate chain");
            return null;
        }
        if (JsseUtils.containsNull(certificateChain = (X509Certificate[])certificateChain.clone())) {
            LOG.finer("Rejecting alias '" + alias + "': invalid certificate chain");
            return null;
        }
        return certificateChain;
    }

    private static PrivateKey getPrivateKey(X509KeyManager x509KeyManager, String alias) {
        PrivateKey privateKey = x509KeyManager.getPrivateKey(alias);
        if (null == privateKey) {
            LOG.finer("Rejecting alias '" + alias + "': no private key");
            return null;
        }
        return privateKey;
    }

    ProvX509Key(String keyType, PrivateKey privateKey, X509Certificate[] certificateChain) {
        this.keyType = keyType;
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
    }

    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    public String getKeyType() {
        return this.keyType;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

