/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.OpenIdConsumer;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.Token;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GoogleImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = -6075582192266022341L;
    private static final String REQUEST_TOKEN_URL = "https://www.google.com/accounts/o8/ud";
    private static final String ACCESS_TOKEN_URL = "https://www.google.com/accounts/OAuthGetAccessToken";
    private static final String OAUTH_SCOPE = "http://www.google.com/m8/feeds/";
    private static final String CONTACTS_FEED_URL = "http://www.google.com/m8/feeds/contacts/default/full/?max-results=1000";
    private static final String CONTACT_NAMESPACE = "http://schemas.google.com/g/2005";
    private static final String PROPERTY_DOMAIN = "www.google.com";
    private final Log LOG = LogFactory.getLog(GoogleImpl.class);
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private Token requestToken;
    private Token accessToken;
    private OAuthConsumer oauth;
    private OAuthConfig config;

    public GoogleImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SocialAuthConfigurationException("www.google.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() == 0) {
            throw new SocialAuthConfigurationException("www.google.com.consumer_key value is null");
        }
        this.oauth = new OAuthConsumer(this.config);
        this.requestToken = null;
        this.accessToken = null;
    }

    @Override
    public String getLoginRedirectURL(String returnTo) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        String associationURL = OpenIdConsumer.getAssociationURL(REQUEST_TOKEN_URL);
        Response r = HttpUtil.doHttpRequest(associationURL, MethodType.GET.toString(), null, null);
        StringBuffer sb = new StringBuffer();
        String assocHandle = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(r.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
                if (line.substring(0, 13) != "assoc_handle:") continue;
                assocHandle = line.substring(13);
                break;
            }
            this.LOG.debug((Object)("ASSOCCIATION : " + assocHandle));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  ");
        }
        String realm = returnTo.substring(0, returnTo.indexOf("/", 9));
        String consumerURL = realm.replace("http://", "");
        this.setProviderState(true);
        String gscope = null;
        if (!Permission.AUHTHENTICATE_ONLY.equals(this.scope)) {
            gscope = OAUTH_SCOPE;
        }
        String url = OpenIdConsumer.getRequestTokenURL(REQUEST_TOKEN_URL, returnTo, realm, assocHandle, consumerURL, gscope);
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.LOG.debug((Object)"Verifying the authentication response from provider");
        if (request.getParameter("openid.mode") != null && "cancel".equals(request.getParameter("openid.mode"))) {
            throw new UserDeniedPermissionException();
        }
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        try {
            this.LOG.debug((Object)"Running OpenID discovery");
            String reqTokenStr = "";
            if (Permission.AUHTHENTICATE_ONLY.equals(this.scope)) {
                return this.getProfile(request);
            }
            if (request.getParameter("openid.ext2.request_token") != null) {
                reqTokenStr = HttpUtil.decodeURIComponent(request.getParameter("openid.ext2.request_token"));
            }
            this.requestToken = new Token();
            this.requestToken.setKey(reqTokenStr);
            this.LOG.debug((Object)"Call to fetch Access Token");
            this.accessToken = this.oauth.getAccessToken(ACCESS_TOKEN_URL, this.requestToken);
            if (this.accessToken == null) {
                throw new SocialAuthConfigurationException("Application keys are not correct. The server running the application should be same that was registered to get the keys.");
            }
            this.isVerify = true;
            this.LOG.debug((Object)"Obtaining profile from OpenID response");
            return this.getProfile(request);
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
    }

    private Profile getProfile(HttpServletRequest req) {
        return OpenIdConsumer.getUserInfo(req);
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Google");
        throw new SocialAuthException("Update Status is not implemented for Gmail");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        this.LOG.info((Object)"Fetching contacts from http://www.google.com/m8/feeds/contacts/default/full/?max-results=1000");
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(CONTACTS_FEED_URL, null, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from http://www.google.com/m8/feeds/contacts/default/full/?max-results=1000", ie);
        }
        ArrayList<Contact> plist = new ArrayList<Contact>();
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts from response.http://www.google.com/m8/feeds/contacts/default/full/?max-results=1000", e);
        }
        NodeList contactsList = root.getElementsByTagName("entry");
        if (contactsList != null && contactsList.getLength() > 0) {
            this.LOG.debug((Object)("Found contacts : " + contactsList.getLength()));
            for (int i = 0; i < contactsList.getLength(); ++i) {
                String[] sarr;
                Element contact = (Element)contactsList.item(i);
                String fname = "";
                NodeList l = contact.getElementsByTagNameNS(CONTACT_NAMESPACE, "email");
                String address = null;
                String[] emailArr = null;
                if (l != null && l.getLength() > 0) {
                    Element el = (Element)l.item(0);
                    if (el != null) {
                        address = el.getAttribute("address");
                    }
                    if (l.getLength() > 1) {
                        emailArr = new String[l.getLength() - 1];
                        for (int k = 1; k < l.getLength(); ++k) {
                            Element e = (Element)l.item(k);
                            if (e == null) continue;
                            emailArr[k - 1] = e.getAttribute("address");
                        }
                    }
                }
                String lname = "";
                String dispName = XMLParseUtil.getElementData(contact, "title");
                if (dispName != null && (sarr = dispName.split(" ")).length > 0) {
                    if (sarr.length >= 1) {
                        fname = sarr[0];
                    }
                    if (sarr.length >= 2) {
                        StringBuilder sb = new StringBuilder();
                        for (int k = 1; k < sarr.length; ++k) {
                            sb.append(sarr[k]).append(" ");
                        }
                        lname = sb.toString();
                    }
                }
                if (address == null || address.length() <= 0) continue;
                Contact p = new Contact();
                p.setFirstName(fname);
                p.setLastName(lname);
                p.setEmail(address);
                p.setDisplayName(dispName);
                p.setOtherEmails(emailArr);
                plist.add(p);
            }
        } else {
            this.LOG.debug((Object)"No contacts were obtained from the feed : http://www.google.com/m8/feeds/contacts/default/full/?max-results=1000");
        }
        return plist;
    }

    @Override
    public void logout() {
        this.requestToken = null;
        this.accessToken = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response serviceResponse = null;
        if (!MethodType.GET.toString().equals(methodType)) {
            throw new SocialAuthException("Only GET method is implemented in Google API function");
        }
        this.LOG.debug((Object)("Calling URL : " + url));
        try {
            serviceResponse = this.oauth.httpGet(url, headerParams, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Error while making request to URL : " + url, ie);
        }
        return serviceResponse;
    }
}

