/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.util.Response;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;

public class OpenIdImpl
extends AbstractProvider
implements AuthProvider {
    private static final long serialVersionUID = -6349104612642490031L;
    private final Log LOG = LogFactory.getLog(OpenIdImpl.class);
    private ConsumerManager manager = new ConsumerManager();
    private DiscoveryInformation discovered;
    private Properties props;

    public OpenIdImpl(Properties props) throws ConsumerException {
        this.props = props;
        this.discovered = null;
    }

    @Override
    public String getLoginRedirectURL(String redirectUri) throws IOException {
        this.setProviderState(true);
        String url = this.authRequest(this.props.getProperty("id"), redirectUri);
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    private String authRequest(String userSuppliedString, String returnToUrl) throws IOException {
        try {
            List discoveries = this.manager.discover(userSuppliedString);
            this.discovered = this.manager.associate(discoveries);
            AuthRequest authReq = this.manager.authenticate(this.discovered, returnToUrl);
            FetchRequest fetch = FetchRequest.createFetchRequest();
            fetch.addAttribute("emailax", "http://axschema.org/contact/email", true);
            fetch.addAttribute("firstnameax", "http://axschema.org/namePerson/first", true);
            fetch.addAttribute("lastnameax", "http://axschema.org/namePerson/last", true);
            fetch.addAttribute("fullnameax", "http://axschema.org/namePerson", true);
            fetch.addAttribute("email", "http://schema.openid.net/contact/email", true);
            fetch.addAttribute("firstname", "http://schema.openid.net/namePerson/first", true);
            fetch.addAttribute("lastname", "http://schema.openid.net/namePerson/last", true);
            fetch.addAttribute("fullname", "http://schema.openid.net/namePerson", true);
            authReq.addExtension((MessageExtension)fetch);
            return authReq.getDestinationUrl(true);
        }
        catch (OpenIDException openIDException) {
            return null;
        }
    }

    @Override
    public Profile verifyResponse(HttpServletRequest httpReq) throws Exception {
        VerificationResult verification;
        Identifier verified;
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        ParameterList response = new ParameterList(httpReq.getParameterMap());
        StringBuffer receivingURL = httpReq.getRequestURL();
        String queryString = httpReq.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(httpReq.getQueryString());
        }
        if ((verified = (verification = this.manager.verify(receivingURL.toString(), response, this.discovered)).getVerifiedId()) != null) {
            this.LOG.debug((Object)("Verified Id : " + verified.getIdentifier()));
            Profile p = new Profile();
            p.setValidatedId(verified.getIdentifier());
            AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                p.setEmail(fetchResp.getAttributeValue("email"));
                p.setFirstName(fetchResp.getAttributeValue("firstname"));
                p.setLastName(fetchResp.getAttributeValue("lastname"));
                p.setFullName(fetchResp.getAttributeValue("fullname"));
                if (p.getEmail() == null) {
                    p.setEmail(fetchResp.getAttributeValue("emailax"));
                }
                if (p.getFirstName() == null) {
                    p.setFirstName(fetchResp.getAttributeValue("firstnameax"));
                }
                if (p.getLastName() == null) {
                    p.setLastName(fetchResp.getAttributeValue("lastnameax"));
                }
                if (p.getFullName() == null) {
                    p.setFullName(fetchResp.getAttributeValue("fullnameax"));
                }
            }
            return p;
        }
        return null;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for OpenId");
        throw new SocialAuthException("Update Status is not implemented for Gmail");
    }

    @Override
    public List<Contact> getContactList() {
        this.LOG.info((Object)"Contacts are not available in OpenId");
        return null;
    }

    @Override
    public void logout() {
        this.discovered = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.warn((Object)"Setting Permission for openid is not valid.");
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.warn((Object)"WARNING: API method is not implemented for OpenId");
        throw new SocialAuthException("API method is not implemented for OpenId");
    }
}

