/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.facebook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Album;
import org.brickred.socialauth.Photo;
import org.brickred.socialauth.plugin.AlbumsPlugin;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlbumsPluginImpl
implements AlbumsPlugin,
Serializable {
    private static final long serialVersionUID = 5350785649768508189L;
    private static final String ALBUMS_URL = "https://graph.facebook.com/me/albums";
    private static final String ALBUM_PHOTOS_URL = "https://graph.facebook.com/%1$s/photos";
    private static final String ALBUM_COVER_URL = "https://graph.facebook.com/%1$s/picture?access_token=%2$s";
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;

    public AlbumsPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Album> getAlbums() throws Exception {
        Response response = this.providerSupport.api(ALBUMS_URL, MethodType.GET.toString(), null, null, null);
        String respStr = response.getResponseBodyAsString("UTF-8");
        this.LOG.debug((Object)("Albums JSON :: " + respStr));
        ArrayList<Album> albums = new ArrayList<Album>();
        JSONObject resp = new JSONObject(respStr);
        JSONArray data = resp.getJSONArray("data");
        this.LOG.debug((Object)("Albums count : " + data.length()));
        for (int i = 0; i < data.length(); ++i) {
            Album album = new Album();
            JSONObject obj = data.getJSONObject(i);
            String albumId = obj.getString("id");
            album.setId(albumId);
            if (obj.has("name")) {
                album.setName(obj.getString("name"));
            }
            if (obj.has("link")) {
                album.setLink(obj.getString("link"));
            }
            if (obj.has("cover_photo")) {
                album.setCoverPhoto(obj.getString("cover_photo"));
            }
            if (obj.has("count")) {
                album.setPhotosCount(obj.getInt("count"));
            }
            album.setCoverPhoto(String.format(ALBUM_COVER_URL, albumId, this.providerSupport.getAccessGrant().getKey()));
            List<Photo> photos = this.getAlbumPhotos(albumId);
            album.setPhotos(photos);
            albums.add(album);
        }
        return albums;
    }

    private List<Photo> getAlbumPhotos(String id) throws Exception {
        Response response = this.providerSupport.api(String.format(ALBUM_PHOTOS_URL, id), MethodType.GET.toString(), null, null, null);
        String respStr = response.getResponseBodyAsString("UTF-8");
        this.LOG.info((Object)("Getting Photos of Album :: " + id));
        JSONObject resp = new JSONObject(respStr);
        JSONArray data = resp.getJSONArray("data");
        this.LOG.debug((Object)("Photos count : " + data.length()));
        ArrayList<Photo> photos = new ArrayList<Photo>();
        for (int i = 0; i < data.length(); ++i) {
            Photo photo = new Photo();
            JSONObject obj = data.getJSONObject(i);
            photo.setId(obj.getString("id"));
            if (obj.has("name")) {
                photo.setTitle(obj.getString("name"));
            }
            if (obj.has("link")) {
                photo.setLink(obj.getString("link"));
            }
            if (obj.has("picture")) {
                photo.setThumbImage(obj.getString("picture"));
            }
            JSONArray images = obj.getJSONArray("images");
            for (int k = 0; k < images.length(); ++k) {
                JSONObject img = images.getJSONObject(k);
                int ht = 0;
                int wt = 0;
                if (img.has("height")) {
                    ht = img.getInt("height");
                }
                if (img.has("width")) {
                    wt = img.getInt("width");
                }
                if (ht == 600 || wt == 600) {
                    photo.setLargeImage(img.getString("source"));
                    continue;
                }
                if (ht == 480 || wt == 480) {
                    photo.setMediumImage(img.getString("source"));
                    continue;
                }
                if (ht != 320 && wt != 320) continue;
                photo.setSmallImage(img.getString("source"));
            }
            photos.add(photo);
        }
        return photos;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

