/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FourSquareImpl
extends AbstractProvider {
    private static final long serialVersionUID = 3364430495809289118L;
    private static final String PROFILE_URL = "https://api.foursquare.com/v2/users/self";
    private static final String CONTACTS_URL = "https://api.foursquare.com/v2/users/self/friends";
    private static final String VIEW_PROFILE_URL = "http://foursquare.com/user/";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(FourSquareImpl.class);
    private Permission scope;
    private String accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;

    public FourSquareImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setAccessTokenParameterName("oauth_token");
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessGrant = accessGrant;
        this.accessToken = accessGrant.getKey();
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("error") != null && "access_denied".equals(requestParams.get("error"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams);
        if (this.accessGrant != null) {
            this.accessToken = this.accessGrant.getKey();
            this.LOG.debug((Object)"Obtaining user profile");
            return this.getProfile();
        }
        throw new SocialAuthException("Access token not found");
    }

    private Profile getProfile() throws Exception {
        JSONObject cobj;
        String res;
        Response serviceResponse;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(PROFILE_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  https://api.foursquare.com/v2/users/self", e);
        }
        try {
            res = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  https://api.foursquare.com/v2/users/self", exc);
        }
        JSONObject jobj = new JSONObject(res);
        if (!jobj.has("response")) {
            throw new SocialAuthException("Failed to parse the user profile json : " + res);
        }
        JSONObject rObj = jobj.getJSONObject("response");
        if (!rObj.has("user")) {
            throw new SocialAuthException("Failed to parse the user profile json : " + res);
        }
        JSONObject uObj = rObj.getJSONObject("user");
        if (uObj.has("id")) {
            profile.setValidatedId(uObj.getString("id"));
        }
        if (uObj.has("firstName")) {
            profile.setFirstName(uObj.getString("firstName"));
        }
        if (uObj.has("lastName")) {
            profile.setLastName(uObj.getString("lastName"));
        }
        if (uObj.has("photo")) {
            profile.setProfileImageURL(uObj.getString("photo"));
        }
        if (uObj.has("gender")) {
            profile.setGender(uObj.getString("gender"));
        }
        if (uObj.has("homeCity")) {
            profile.setLocation(uObj.getString("homeCity"));
        }
        if (uObj.has("contact") && (cobj = uObj.getJSONObject("contact")).has("email")) {
            profile.setEmail(cobj.getString("email"));
        }
        profile.setProviderId(this.getProviderId());
        this.userProfile = profile;
        return profile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        Response serviceResponse;
        this.LOG.info((Object)"Fetching contacts from https://api.foursquare.com/v2/users/self/friends");
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(CONTACTS_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from https://api.foursquare.com/v2/users/self/friends", e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Error while getting contacts from https://api.foursquare.com/v2/users/self/friendsStatus : " + serviceResponse.getStatus());
        }
        try {
            respStr = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  https://api.foursquare.com/v2/users/self/friends", exc);
        }
        this.LOG.debug((Object)("User Contacts list in JSON " + respStr));
        JSONObject resp = new JSONObject(respStr);
        ArrayList<Contact> plist = new ArrayList<Contact>();
        JSONArray items = new JSONArray();
        if (!resp.has("response")) throw new SocialAuthException("Failed to parse the user profile json : " + respStr);
        JSONObject robj = resp.getJSONObject("response");
        if (!robj.has("friends")) throw new SocialAuthException("Failed to parse the user profile json : " + respStr);
        JSONObject fobj = robj.getJSONObject("friends");
        if (fobj.has("items")) {
            items = fobj.getJSONArray("items");
        }
        this.LOG.debug((Object)("Contacts Found : " + items.length()));
        for (int i = 0; i < items.length(); ++i) {
            String photo;
            JSONObject obj = items.getJSONObject(i);
            Contact c = new Contact();
            if (obj.has("firstName")) {
                c.setFirstName(obj.getString("firstName"));
            }
            if (obj.has("lastName")) {
                c.setLastName(obj.getString("lastName"));
            }
            if (obj.has("id")) {
                c.setProfileUrl(VIEW_PROFILE_URL + obj.getString("id"));
                c.setId(obj.getString("id"));
            }
            if (obj.has("photo") && (photo = obj.getString("photo")).length() > 1) {
                c.setProfileImageURL(photo);
            }
            plist.add(c);
        }
        return plist;
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for FourSquare");
        throw new SocialAuthException("Update Status is not implemented for FourSquare");
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for FourSquare");
        throw new SocialAuthException("Update Status is not implemented for FourSquare");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        ENDPOINTS.put("authorizationURL", "https://foursquare.com/oauth2/authenticate");
        ENDPOINTS.put("accessTokenURL", "https://foursquare.com/oauth2/access_token");
    }
}

