/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.util.Map;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.Response;

public class ProviderSupport {
    private OAuthStrategyBase authenticationStrategy;

    public ProviderSupport(OAuthStrategyBase strategy) {
        this.authenticationStrategy = strategy;
    }

    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    public Response api(String url) throws Exception {
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, MethodType.GET.toString(), null, null, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    public AccessGrant getAccessGrant() {
        return this.authenticationStrategy.getAccessGrant();
    }
}

