/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.twitter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Album;
import org.brickred.socialauth.Photo;
import org.brickred.socialauth.plugin.AlbumsPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlbumsPluginImpl
implements AlbumsPlugin,
Serializable {
    private static final long serialVersionUID = -4810906169491380470L;
    private static final String FEED_URL = "https://api.twitter.com/1.1/statuses/home_timeline.json?include_entities=true&count=100";
    private final Log LOG = LogFactory.getLog(this.getClass());
    private HashMap<String, List<Photo>> photo_data = new HashMap();
    private ProviderSupport providerSupport;

    public AlbumsPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Album> getAlbums() throws Exception {
        Response response = null;
        ArrayList<Album> albums = new ArrayList<Album>();
        this.LOG.info((Object)"Getting feeds from URL : https://api.twitter.com/1.1/statuses/home_timeline.json?include_entities=true&count=100");
        response = this.providerSupport.api(FEED_URL);
        String respStr = response.getResponseBodyAsString("UTF-8");
        this.LOG.debug((Object)("Feeds json string :: " + respStr));
        JSONArray jarr = new JSONArray(respStr);
        this.LOG.debug((Object)("Feeds count :: " + jarr.length()));
        int i = 0;
        while (i < jarr.length()) {
            Album album = new Album();
            JSONObject jobj = jarr.getJSONObject(i);
            if (jobj.has("user")) {
                JSONObject mediaObj;
                JSONObject entitiesObj;
                JSONObject userObj = jobj.getJSONObject("user");
                if (jobj.has("entities") && (entitiesObj = jobj.getJSONObject("entities")).has("media") && (mediaObj = entitiesObj.getJSONArray("media").getJSONObject(0)).has("type") && mediaObj.optString("type").equalsIgnoreCase("photo") && userObj.optString("name", null) != null && mediaObj.optString("media_url", null) != null) {
                    List<Photo> photos = this.photo_data.get(userObj.optString("name"));
                    if (photos == null) {
                        photos = new ArrayList<Photo>();
                        this.photo_data.put(userObj.optString("name", null), photos);
                        album.setName(userObj.optString("name", null));
                        album.setCoverPhoto(userObj.optString("profile_image_url").replaceAll("_normal", "_reasonably_small"));
                        albums.add(album);
                    }
                    Photo photo = new Photo();
                    String photoURL = mediaObj.getString("media_url");
                    photo.setThumbImage(String.valueOf(photoURL) + ":thumb");
                    photo.setSmallImage(String.valueOf(photoURL) + ":small");
                    photo.setMediumImage(photoURL);
                    photo.setLargeImage(String.valueOf(photoURL) + ":large");
                    photo.setTitle(jobj.optString("text", null));
                    photo.setId(mediaObj.optString("id_str", null));
                    photo.setLink(mediaObj.optString("expanded_url", null));
                    if (jobj.has("retweet_count")) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("retweet_count", String.valueOf(jobj.optInt("retweet_count")));
                        photo.setMetaData(map);
                    }
                    photos.add(photo);
                }
            }
            ++i;
        }
        for (Album album : albums) {
            List<Photo> photos = this.photo_data.get(album.getName());
            album.setPhotos(photos);
            album.setPhotosCount(photos.size());
        }
        return albums;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

