/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.ServerThread;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.buni.meldware.mail.util.io.IOUtil;
import org.jboss.logging.Logger;

public abstract class AbstractProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(AbstractProtocol.class);
    private static final String ENCODING = "US-ASCII";
    private ServerThread serverThread;
    private Map state = new HashMap();
    protected Map properties;
    protected boolean secure = false;
    protected ObjectName parent;

    public AbstractProtocol() {
        this.properties = new HashMap();
    }

    public AbstractProtocol(ObjectName parent) {
        this.parent = parent;
    }

    public Object getOldProperty(String name) {
        Object ret = null;
        if (this.properties != null) {
            ret = this.properties.get(name);
        }
        return ret;
    }

    public Object getProperty(String name) {
        MBeanServer server = MMJMXUtil.locateJBoss();
        Object val = null;
        try {
            val = server.getAttribute(this.parent, name);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to retrieve property: " + name), (Throwable)e);
        }
        return val;
    }

    public long getOldPropertyLong(String name) {
        Object val;
        long lval = 0L;
        if (this.properties != null && (val = this.properties.get(name)) != null && val instanceof Long) {
            lval = (Long)val;
        }
        return lval;
    }

    public long getPropertyLong(String name) {
        long lval = 0L;
        MBeanServer server = MMJMXUtil.locateJBoss();
        try {
            Object val = server.getAttribute(this.parent, name);
            if (val != null && val instanceof Long) {
                lval = (Long)val;
            } else if (val != null && val instanceof Integer) {
                lval = ((Integer)val).longValue();
            } else if (val != null && val instanceof Short) {
                lval = ((Short)val).longValue();
            } else if (val != null) {
                log.warn((Object)("Property: " + name + " of wrong type: " + val.getClass()));
            } else {
                log.warn((Object)("Property: " + name + " is null"));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to retrieve property: " + name), (Throwable)e);
        }
        return lval;
    }

    public boolean getOldPropertyBool(String name) {
        Object val;
        boolean bval = false;
        if (this.properties != null && (val = this.properties.get(name)) != null && val instanceof Boolean) {
            bval = (Boolean)val;
        }
        return bval;
    }

    public boolean getPropertyBool(String name) {
        boolean bval = false;
        MBeanServer server = MMJMXUtil.locateJBoss();
        try {
            Object val = server.getAttribute(this.parent, name);
            if (val != null && val instanceof Boolean) {
                bval = (Boolean)val;
            } else if (val != null) {
                log.warn((Object)("Property: " + name + " of wrong type: " + val.getClass()));
            } else {
                log.warn((Object)("Property: " + name + " is null"));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to retrieve property: " + name), (Throwable)e);
        }
        return bval;
    }

    public Object getState(String name) {
        return this.state.get(name);
    }

    public void setState(String name, Object value) {
        this.state.put(name, value);
    }

    public void resetState() {
        this.state = new HashMap();
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    protected String readCommand(InputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder();
        IOUtil.appendLine((StringBuilder)sb, (InputStream)stream, (String)ENCODING);
        return sb.toString();
    }

    protected String[] parseCommand(String commandstring) {
        String command = commandstring;
        String argument = null;
        int spaceIndex = command.indexOf(" ");
        if (spaceIndex > 0) {
            argument = command.substring(spaceIndex + 1);
            command = command.substring(0, spaceIndex);
        }
        command = command.toUpperCase(Locale.US);
        return new String[]{command, argument};
    }

    public ServerThread getServerThread() {
        return this.serverThread;
    }

    public void setServerThread(ServerThread serverThread) {
        this.serverThread = serverThread;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setParent(ObjectName parent) {
        this.parent = parent;
    }

    public ObjectName getParent() {
        return this.parent;
    }

    public void sendForceClose(OutputStream out) throws IOException {
    }
}

