/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.buni.meldware.mail.ServerMBean;
import org.buni.meldware.mail.ThreadPoolMBean;
import org.jboss.security.SecurityDomain;
import org.jboss.system.ServiceMBeanSupport;

public class Server
extends ServiceMBeanSupport
implements ServerMBean,
Runnable {
    private ServerSocket serverSocket;
    protected ThreadPoolMBean pool;
    private String sslDomain;
    private SSLServerSocketFactory sslServerSocketFactory;
    protected int port;
    private int backlog;
    protected long life;
    protected long timeout;
    protected String address;
    private boolean shutdown = false;
    private Thread serverThread;
    protected ObjectName protocolName;
    private int poolsize;
    private boolean usesSSL;

    private String trimName(String thename) {
        int loc = thename.indexOf(":");
        String parsedname = thename.substring(loc + 1, thename.length());
        return parsedname;
    }

    private boolean isJMX(String thename) {
        return thename.length() > 3 ? thename.substring(0, 4).equals("jmx:") : false;
    }

    public ObjectName getProtocol() {
        return this.protocolName;
    }

    public void setProtocol(ObjectName protocol) {
        if (protocol == null || this.protocolName == null || !protocol.equals(this.protocolName)) {
            this.protocolName = protocol;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public long getLife() {
        return this.life;
    }

    public void setLife(long life) {
        this.life = life;
    }

    public Server(int port, int backlog, String address, ObjectName protocol, long timeout, long life) {
        this.port = port;
        this.backlog = backlog;
        this.address = address;
    }

    public Server() {
    }

    public void setThreadPool(ThreadPoolMBean tp) {
        this.pool = tp;
    }

    public ThreadPoolMBean getThreadPool() {
        return this.pool;
    }

    public void startService() throws Exception {
        this.log.info((Object)"starting Server Service instance");
        this.setupSSLServerSocketFactory();
        this.log.info((Object)"starting serverThread...");
        this.serverThread = new Thread(this);
        this.serverThread.start();
        this.log.info((Object)"serverThread started");
        this.log.info((Object)"started Server Service instance");
    }

    public void stopService() {
        this.log.info((Object)"**** stopping Server Service instance");
        try {
            this.serverSocket.close();
            this.serverThread.interrupt();
        }
        catch (Exception exception) {}
        this.log.info((Object)"**** stopped Server Service instance");
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void run() {
        block6: {
            try {
                if (this.isUsesSSL()) {
                    this.serverSocket = this.sslServerSocketFactory.createServerSocket(this.port, this.backlog, InetAddress.getByName(this.address));
                    break block6;
                }
                this.serverSocket = new ServerSocket(this.port, this.backlog, InetAddress.getByName(this.address));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        while (!this.shutdown) {
            Socket socket = null;
            try {
                this.log.debug((Object)"waiting for request");
                socket = this.serverSocket.accept();
                this.log.debug((Object)"Got request");
                this.pool.handleConnection(socket, this.protocolName, this.timeout, System.currentTimeMillis() + this.life);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    public boolean isUsesSSL() {
        return this.usesSSL;
    }

    public void setUsesSSL(boolean usesSSL) {
        this.usesSSL = usesSSL;
    }

    private void setupSSLServerSocketFactory() throws RuntimeException {
        SSLServerSocketFactory sslServerSocketFactory = null;
        if (this.sslDomain != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> sfClass;
                try {
                    sfClass = loader.loadClass("org.jboss.security.ssl.DomainServerSocketFactory");
                    sslServerSocketFactory = (SSLServerSocketFactory)sfClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create SSLSocketFactory", e);
                }
                sfClass = sslServerSocketFactory.getClass();
                InitialContext ctx = new InitialContext();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = sfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)sslServerSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
                throw new RuntimeException("Could not set up security for TLS", e);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory"), (Throwable)e);
                throw new RuntimeException("Could not set up security for TLS", e);
            }
        }
        if (this.isUsesSSL()) {
            this.log.error((Object)"usesSSL was set to true, but no SecurityDomain was specified");
            throw new RuntimeException("No SecurityDomain was specified");
        }
        this.sslServerSocketFactory = sslServerSocketFactory;
    }

    public void setSslDomain(String domainName) {
        try {
            this.log.debug((Object)"setSecurityDomain()");
            this.sslDomain = domainName;
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error", (Throwable)e);
            throw e;
        }
    }

    public String getSslDomain() {
        return this.sslDomain;
    }
}

