/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.api.Mailbox;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class DeleteCommand
extends AbstractImapCommand {
    String _folder;

    public DeleteCommand() {
        super("DELETE");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 1;
    }

    public IMAP4Response execute() {
        IMAP4Response res = this.constructResponse();
        IMAP4ProtocolInstance protocol = this.getProtocolInstance();
        String[] path = this.getPath(this.getFolder());
        Mailbox mbox = protocol.getMailboxProxy();
        try {
            mbox.deleteFolder(path);
            this.taggedSimpleSuccess();
        }
        catch (MailException mailException) {
            this.taggedFailure(String.valueOf(this.getCmdName()) + " mailbox does not exist.");
        }
        return res;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setFolder(String mailbox) {
        this._folder = mailbox;
    }
}

