/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailhandler.remote;

import java.util.ArrayList;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.MailListener;
import org.buni.meldware.mail.domaingroup.DomainGroupMBean;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailhandler.remote.RemoteDeliveryMBean;
import org.buni.meldware.mail.message.BouncedMail;
import org.buni.meldware.mail.message.EnvelopedAddress;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailRetryWrapper;
import org.buni.meldware.mail.message.Message;
import org.buni.meldware.mail.smtp.sender.SMTPResult;
import org.buni.meldware.mail.smtp.sender.SMTPSenderMBean;
import org.jboss.logging.Logger;

public class RemoteDelivery
implements RemoteDeliveryMBean {
    private Logger log = Logger.getLogger(RemoteDelivery.class);
    private MailListener router;
    private DomainGroupMBean domainGroup;
    private SMTPSenderMBean sender;
    private MailboxService mailboxService;

    public Message send(Message msg) throws MailException {
        Mail smtpMessage = (Mail)msg;
        ArrayList<EnvelopedAddress> excluded = new ArrayList<EnvelopedAddress>();
        for (MailAddress address : smtpMessage.getTo()) {
            EnvelopedAddress ea = new EnvelopedAddress(address);
            if (!ea.getLocal()) continue;
            excluded.add(ea);
        }
        MailAddress[] excludedArr = excluded.toArray(new MailAddress[excluded.size()]);
        SMTPResult[] results = this.deliver(excludedArr, smtpMessage);
        int i = 0;
        while (i < results.length) {
            this.log.debug((Object)("Delivery result - " + results[i]));
            ++i;
        }
        ArrayList<MailAddress> redeliveries = new ArrayList<MailAddress>();
        int i2 = 0;
        while (i2 < results.length) {
            if (results[i2].redeliver()) {
                redeliveries.add(results[i2].getAddress());
            }
            ++i2;
        }
        ArrayList<MailAddress> invalidAddresses = new ArrayList<MailAddress>();
        int i3 = 0;
        while (i3 < results.length) {
            if (results[i3].getStatus() == 4) {
                invalidAddresses.add(results[i3].getAddress());
            }
            ++i3;
        }
        this.log.debug((Object)("Redelivering to " + redeliveries.size() + " recipients"));
        if (redeliveries.size() > 0) {
            MailRetryWrapper mailWrp = smtpMessage instanceof MailRetryWrapper ? (MailRetryWrapper)smtpMessage : new MailRetryWrapper(smtpMessage, MailRetryWrapper.REDELIVERY_REMOTE);
            mailWrp.setTos(redeliveries);
            this.router.send((Message)mailWrp);
        }
        this.log.debug((Object)("Bouncing " + invalidAddresses.size() + " recipients: " + invalidAddresses));
        if (invalidAddresses.size() > 0) {
            MailAddress[] bounced = invalidAddresses.toArray(new MailAddress[0]);
            BouncedMail bounceMail = new BouncedMail(this.sender.getMailBodyManager(), smtpMessage, bounced, MailAddress.parseSMTPStyle((String)this.domainGroup.getPostmaster()));
            this.router.send((Message)bounceMail);
        }
        return msg;
    }

    private SMTPResult[] deliver(MailAddress[] excluded, Mail message) {
        this.log.debug((Object)("deliver - exclude:" + excluded));
        return this.sender.send(message, excluded);
    }

    public DomainGroupMBean getDomainGroup() {
        return this.domainGroup;
    }

    public void setDomainGroup(DomainGroupMBean domainGroup) {
        this.domainGroup = domainGroup;
    }

    public MailListener getRouter() {
        return this.router;
    }

    public void setRouter(MailListener router) {
        this.router = router;
    }

    public SMTPSenderMBean getSender() {
        return this.sender;
    }

    public void setSender(SMTPSenderMBean sender) {
        this.sender = sender;
    }

    public void setMailbox(MailboxService service) {
        this.mailboxService = service;
    }
}

