/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.maillistener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.MailListener;
import org.buni.meldware.mail.domaingroup.DomainGroupMBean;
import org.buni.meldware.mail.maillistener.JMSMailListenerMBean;
import org.buni.meldware.mail.maillistener.PreparedMail;
import org.buni.meldware.mail.message.BouncedMail;
import org.buni.meldware.mail.message.EnvelopedAddress;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.MailRetryWrapper;
import org.buni.meldware.mail.message.Message;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JMSMailListener
extends ServiceMBeanSupport
implements JMSMailListenerMBean,
MailListener {
    private static final Logger jblog = Logger.getLogger(JMSMailListener.class);
    private String onServer;
    private String offServer;
    ObjectName domainGroup;
    DomainGroupMBean domainGroupMBean;
    private ConnectionFactory cf;
    private Destination onServerDest;
    private Destination offServerDest;
    private String connectionFactoryName;
    private long[] localRetryIntervals = new long[0];
    private long[] remoteRetryIntervals = new long[0];
    private boolean useTx;
    private MailBodyManager mgr;

    public JMSMailListener(String connectionFactoryName, boolean useTx) {
        this.connectionFactoryName = connectionFactoryName;
        this.useTx = useTx;
    }

    public void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        this.cf = (ConnectionFactory)ctx.lookup(this.connectionFactoryName);
        this.onServerDest = (Destination)ctx.lookup(this.onServer);
        this.offServerDest = (Destination)ctx.lookup(this.offServer);
    }

    public void stopService() throws Exception {
    }

    public void setOnServerPostDestination(String postDest) {
        this.onServer = postDest;
    }

    public void setOffServerPostDestination(String postDest) {
        this.offServer = postDest;
    }

    public String getOnServerPostDestination() {
        return this.onServer;
    }

    public String getOffServerPostDestination() {
        return this.offServer;
    }

    public void setLocalRetryTimes(Element localRetryTimes) {
        NodeList nodes = localRetryTimes.getElementsByTagName("retryTime");
        int length = nodes.getLength();
        this.localRetryIntervals = new long[length];
        int i = 0;
        while (i < length) {
            Node node = nodes.item(i);
            String time = node.getFirstChild().getNodeValue();
            this.localRetryIntervals[i] = Long.parseLong(time);
            ++i;
        }
    }

    public Element getLocalRetryTimes() {
        return null;
    }

    public void setRemoteRetryTimes(Element remoteRetryTimes) {
        NodeList nodes = remoteRetryTimes.getElementsByTagName("retryTime");
        int length = nodes.getLength();
        this.remoteRetryIntervals = new long[length];
        int i = 0;
        while (i < length) {
            Node node = nodes.item(i);
            String time = node.getFirstChild().getNodeValue();
            this.remoteRetryIntervals[i] = Long.parseLong(time);
            ++i;
        }
    }

    public Element getRemoteRetryTimes() {
        return null;
    }

    public void setDomainGroup(ObjectName domainGroup) {
        this.domainGroup = domainGroup;
        try {
            this.domainGroupMBean = MMJMXUtil.getMBean(domainGroup, DomainGroupMBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("could not set domain group due to JMX issues");
        }
    }

    public ObjectName getDomainGroup() {
        return this.domainGroup;
    }

    public String getDestinationForMailAddress(MailAddress ma) {
        String domain = ma.getDomain();
        if (this.domainGroupMBean.isInGroup(domain)) {
            return this.onServer;
        }
        return this.offServer;
    }

    public Message send(Message msg) {
        try {
            Mail mail = (Mail)msg;
            PreparedMail preparedMail = this.prepareMail(mail);
            Connection cn = this.cf.createConnection();
            Session ses = cn.createSession(true, 0);
            try {
                if (preparedMail != null) {
                    if (preparedMail.getSendOnServer()) {
                        this.putMessage(ses, this.onServerDest, preparedMail);
                    }
                    if (preparedMail.getSendOffServer()) {
                        this.putMessage(ses, this.offServerDest, preparedMail);
                    }
                } else {
                    jblog.warn((Object)"Prepared mail was null.");
                }
            }
            finally {
                if (!this.useTx) {
                    ses.commit();
                }
                ses.close();
                cn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return msg;
    }

    private void putMessage(Session ses, Destination dest, PreparedMail preparedMail) throws Exception {
        MessageProducer sender = ses.createProducer(dest);
        this.log.info((Object)("PUT MESSAGE ON QUEUE:" + preparedMail.getMail()));
        ObjectMessage om = ses.createObjectMessage((Serializable)preparedMail.getMail());
        long secondsDelay = preparedMail.getRetrySeconds();
        if (secondsDelay > 0L) {
            long deliveryTime = new Date().getTime() + secondsDelay * 1000L;
            om.setLongProperty("JMS_JBOSS_SCHEDULED_DELIVERY", deliveryTime);
        }
        sender.send((javax.jms.Message)om);
        sender.close();
    }

    private PreparedMail prepareMail(Mail mail) throws MailException {
        if (mail instanceof MailRetryWrapper) {
            return this.prepareResentMail((MailRetryWrapper)mail);
        }
        return this.prepareNewMail(mail);
    }

    private PreparedMail prepareResentMail(MailRetryWrapper mail) throws MailException {
        boolean mailIsLocal = mail.getRedeliveryDestination() == MailRetryWrapper.REDELIVERY_LOCAL;
        int retryNumber = mail.getRetryNumber();
        try {
            PreparedMail preparedMail = new PreparedMail((Mail)mail);
            if (mailIsLocal) {
                preparedMail.setRetrySeconds(this.localRetryIntervals[retryNumber]);
                preparedMail.setSendOnServer(true);
            } else {
                preparedMail.setRetrySeconds(this.remoteRetryIntervals[retryNumber]);
                preparedMail.setSendOffServer(true);
            }
            mail.increaseRetries();
            return preparedMail;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.prepareBounceMessageForMail(mail, mailIsLocal);
        }
    }

    private PreparedMail prepareBounceMessageForMail(MailRetryWrapper mail, boolean mailIsLocal) throws MailException {
        if (!mail.getSender().isEmpty()) {
            ArrayList<MailAddress> failed = new ArrayList<MailAddress>();
            for (MailAddress address : mail.getTo()) {
                EnvelopedAddress ea = new EnvelopedAddress(address);
                boolean local = ea.getLocal();
                if (local != mailIsLocal) continue;
                failed.add(address);
            }
            if (failed.size() > 0) {
                MailAddress[] failedaddrs = failed.toArray(new MailAddress[failed.size()]);
                BouncedMail bouncedMail = new BouncedMail(this.mgr, (Mail)mail, failedaddrs, MailAddress.parseSMTPStyle((String)this.domainGroupMBean.getPostmaster()));
                PreparedMail preparedMail = new PreparedMail((Mail)bouncedMail);
                preparedMail = this.determineDestinationsInMail(preparedMail);
                return preparedMail;
            }
        }
        return null;
    }

    private PreparedMail prepareNewMail(Mail mail) {
        PreparedMail preparedMail = new PreparedMail(mail);
        return this.determineDestinationsInMail(preparedMail);
    }

    private PreparedMail determineDestinationsInMail(PreparedMail pMail) {
        for (EnvelopedAddress address : pMail.getMail().getRecipients()) {
            String dest = this.getDestinationForMailAddress((MailAddress)address);
            if (dest.equals(this.onServer)) {
                address.setLocal(true);
                pMail.setSendOnServer(true);
                continue;
            }
            if (!dest.equals(this.offServer)) continue;
            address.setLocal(false);
            pMail.setSendOffServer(true);
        }
        return pMail;
    }

    public void setMailBodyManager(MailBodyManager mgr) {
        this.mgr = mgr;
    }
}

