/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;

public class CmdLIST
extends AbstractCommand
implements POP3Handler,
POP3UserMessages {
    public static final String COMMAND = "LIST";
    private static final Logger log = Logger.getLogger(CmdLIST.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException, MailException {
        log.debug((Object)"LIST command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String[] arguments = request.getArguments();
        if (this.verifyState(protocol, writer, 1)) {
            if (arguments.length == 0) {
                List<MessageData> messages = protocol.getInboxMailList();
                long totalSize = 0L;
                long size = 0L;
                StringBuffer messageOutput = new StringBuffer();
                int index = 0;
                while (index < messages.size()) {
                    MessageData data = messages.get(index);
                    if (!data.isDeleted()) {
                        size = data.getSize();
                        totalSize += size;
                        messageOutput.append(String.valueOf(index + 1) + " " + size + "\r\n");
                    }
                    ++index;
                }
                writer.println("+OK " + messages.size() + " messages (" + totalSize + " octets)");
                writer.print(messageOutput.toString());
                writer.println(".");
            } else if (arguments.length == 1) {
                MessageData message = protocol.getMessageAt(Integer.parseInt(arguments[0]));
                if (message == null || message.isDeleted()) {
                    writer.println("-ERR Unknown message.");
                } else {
                    writer.println("+OK " + arguments[0] + " " + message.getSize());
                }
            } else {
                writer.println("-ERR Too many parameters specified.");
            }
        }
        writer.flush();
        return response;
    }
}

