/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp;

import java.lang.reflect.Method;
import java.util.Map;
import javax.naming.InitialContext;
import javax.net.ssl.SSLSocketFactory;
import org.buni.meldware.mail.MailListenerChain;
import org.buni.meldware.mail.domaingroup.DomainGroupMBean;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPProtocolMBean;
import org.buni.meldware.mail.smtp.handlers.SMTPHandlers;
import org.buni.meldware.mail.userrepository.UserRepository;
import org.jboss.security.SecurityDomain;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class SMTPProtocol
extends ServiceMBeanSupport
implements SMTPConstants,
SMTPProtocolMBean {
    Map handlers = SMTPHandlers.instance();
    private DomainGroupMBean domainGroup;
    private MailBodyManager mailBodyManager;
    private UserRepository userRepository;
    private String servername;
    private boolean authRequired;
    private boolean authAllowed;
    private String authMethods;
    private boolean verifyIdentity;
    private int maxMessageSize;
    private int blockSize;
    private boolean requireTls;
    private boolean requireTlsForAuth;
    private boolean requireClientCert;
    private boolean tlsEnabled;
    private String postMaster;
    private int maxReceivedHdrs;
    private int receivedHdrsThreshold;
    private int maxOwnReceivedHdrs;
    private boolean relayByAddr;
    private boolean relayByDomain;
    private DomainGroupMBean relayDomainGroup;
    private SSLSocketFactory sslSocketFactory;
    protected String sslDomain;
    private MailListenerChain chain;

    public String getName() {
        return "SMTP";
    }

    public Element getProperties() {
        return null;
    }

    public SMTPProtocolInstance createInstance() {
        return new SMTPProtocolInstance(this.handlers, this.getServiceName(), this.getMailBodyManager());
    }

    public void setDomainGroup(DomainGroupMBean domainGroup) {
        this.domainGroup = domainGroup;
    }

    public DomainGroupMBean getDomainGroup() {
        return this.domainGroup;
    }

    public void setSecurityDomain(String domainName) {
        try {
            this.log.debug((Object)"setSecurityDomain()");
            this.sslDomain = domainName;
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error", (Throwable)e);
            throw e;
        }
    }

    public String getSecurityDomain() {
        return this.sslDomain;
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"startService()");
        this.setupSSLSocketFactory();
    }

    private void setupSSLSocketFactory() throws RuntimeException {
        SSLSocketFactory sslSocketFactory = null;
        if (this.sslDomain != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> sfClass;
                try {
                    sfClass = loader.loadClass("org.jboss.security.ssl.DomainSocketFactory");
                    sslSocketFactory = (SSLSocketFactory)sfClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create SSLSocketFactory", e);
                }
                sfClass = sslSocketFactory.getClass();
                InitialContext ctx = new InitialContext();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = sfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)sslSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
                throw new RuntimeException("Could not set up security for TLS", e);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory"), (Throwable)e);
                throw new RuntimeException("Could not set up security for TLS", e);
            }
        }
        if (this.isTlsEnabled()) {
            throw new RuntimeException("tls-enabled was set to true, but no SecurityDomain was specified");
        }
        if (this.isRequireTls()) {
            throw new RuntimeException("requireSTARTTLS was set to true, but no SecurityDomain was specified");
        }
        this.setSslSocketFactory(sslSocketFactory);
    }

    public void setListenerChain(MailListenerChain chain) {
        this.chain = chain;
    }

    public MailListenerChain getListenerChain() {
        return this.chain;
    }

    public MailBodyManager getMailBodyManager() {
        return this.mailBodyManager;
    }

    public void setMailBodyManager(MailBodyManager mailBodyManager) {
        this.mailBodyManager = mailBodyManager;
    }

    public String getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(String authMethods) {
        this.authMethods = authMethods;
    }

    public boolean isAuthAllowed() {
        return this.authAllowed;
    }

    public void setAuthAllowed(boolean authAllowed) {
        this.authAllowed = authAllowed;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxOwnReceivedHdrs() {
        return this.maxOwnReceivedHdrs;
    }

    public void setMaxOwnReceivedHdrs(int maxOwnReceivedHdrs) {
        this.maxOwnReceivedHdrs = maxOwnReceivedHdrs;
    }

    public int getMaxReceivedHdrs() {
        return this.maxReceivedHdrs;
    }

    public void setMaxReceivedHdrs(int maxReceivedHdrs) {
        this.maxReceivedHdrs = maxReceivedHdrs;
    }

    public String getPostmaster() {
        return this.postMaster;
    }

    public void setPostmaster(String postMaster) {
        this.postMaster = postMaster;
    }

    public int getReceivedHdrsThreshold() {
        return this.receivedHdrsThreshold;
    }

    public void setReceivedHdrsThreshold(int receivedHdrsThreshold) {
        this.receivedHdrsThreshold = receivedHdrsThreshold;
    }

    public boolean isRequireClientCert() {
        return this.requireClientCert;
    }

    public void setRequireClientCert(boolean requireClientCert) {
        this.requireClientCert = requireClientCert;
    }

    public boolean isRequireTls() {
        return this.requireTls;
    }

    public void setRequireTls(boolean requireTls) {
        this.requireTls = requireTls;
    }

    public boolean isRequireTlsForAuth() {
        return this.requireTlsForAuth;
    }

    public void setRequireTlsForAuth(boolean requireTlsForAuth) {
        this.requireTlsForAuth = requireTlsForAuth;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public String getSslDomain() {
        return this.sslDomain;
    }

    public void setSslDomain(String sslDomain) {
        this.sslDomain = sslDomain;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public boolean isVerifyIdentity() {
        return this.verifyIdentity;
    }

    public void setVerifyIdentity(boolean verifyIdentity) {
        this.verifyIdentity = verifyIdentity;
    }

    public boolean isRelayByAddr() {
        return this.relayByAddr;
    }

    public void setRelayByAddr(boolean relayByAddr) {
        this.relayByAddr = relayByAddr;
    }

    public boolean isRelayByDomain() {
        return this.relayByDomain;
    }

    public void setRelayByDomain(boolean relayByDomain) {
        this.relayByDomain = relayByDomain;
    }

    public DomainGroupMBean getRelayDomainGroup() {
        return this.relayDomainGroup;
    }

    public void setRelayDomainGroup(DomainGroupMBean relayDomainGroup) {
        this.relayDomainGroup = relayDomainGroup;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public Class getProtocolInterfaceClass() {
        return SMTPProtocolMBean.class;
    }

    public static class State {
        public static final String USER = "USER";
    }
}

