/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.CacheEntry;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.io.LoadExceptionInfo;

class CompactEntry<K, V>
implements CacheEntry<K, V> {
    protected static final InitialValueInEntryNeverReturned INITIAL_VALUE = new InitialValueInEntryNeverReturned();
    protected volatile long nextRefreshTime;
    private final K key;
    private volatile Object valueOrException = INITIAL_VALUE;
    public final int hashCode;
    public Entry<K, V> another;
    public long hitCnt;

    CompactEntry(K key, int hashCode) {
        this.key = key;
        this.hashCode = hashCode;
    }

    public void setValueOrException(Object valueOrException) {
        this.valueOrException = valueOrException;
    }

    public LoadExceptionInfo<K, V> getExceptionInfo() {
        if (this.valueOrException instanceof ExceptionWrapper) {
            return (ExceptionWrapper)this.valueOrException;
        }
        return null;
    }

    public boolean hasException() {
        return this.valueOrException instanceof ExceptionWrapper;
    }

    public boolean equalsValue(V v) {
        Object ve = this.valueOrException;
        if (ve == null) {
            return v == ve;
        }
        return ve.equals(v);
    }

    @Deprecated
    public V getValue() {
        return (V)this.valueOrException;
    }

    public Object getValueOrException() {
        return this.valueOrException;
    }

    public K getKey() {
        if (this.key == null) {
            return (K)Integer.valueOf(this.hashCode);
        }
        return this.key;
    }

    public K getKeyObj() {
        return this.key;
    }

    private static class InitialValueInEntryNeverReturned {
        private InitialValueInEntryNeverReturned() {
        }
    }
}

