/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.rest.dto.AuthorizationExceptionDto;
import org.camunda.bpm.engine.rest.dto.ExceptionDto;
import org.camunda.bpm.engine.rest.dto.ParseExceptionDto;
import org.camunda.bpm.engine.rest.dto.migration.MigratingProcessInstanceValidationExceptionDto;
import org.camunda.bpm.engine.rest.dto.migration.MigrationPlanValidationExceptionDto;
import org.camunda.bpm.engine.rest.exception.ExceptionLogger;
import org.camunda.bpm.engine.rest.exception.RestException;

public class ExceptionHandlerHelper {
    protected static final ExceptionLogger LOGGER = ExceptionLogger.REST_LOGGER;
    protected static ExceptionHandlerHelper INSTANCE = new ExceptionHandlerHelper();

    private ExceptionHandlerHelper() {
    }

    public static ExceptionHandlerHelper getInstance() {
        return INSTANCE;
    }

    public Response getResponse(Throwable throwable) {
        LOGGER.log(throwable);
        Response.Status responseStatus = this.getStatus(throwable);
        ExceptionDto exceptionDto = this.fromException(throwable);
        this.provideExceptionCode(throwable, exceptionDto);
        return Response.status((Response.Status)responseStatus).entity((Object)exceptionDto).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected void provideExceptionCode(Throwable throwable, ExceptionDto exceptionDto) {
        Throwable cause;
        Integer code = null;
        if (throwable instanceof ProcessEngineException) {
            code = this.getCode(throwable);
        } else if (throwable instanceof RestException && (cause = throwable.getCause()) instanceof ProcessEngineException) {
            code = this.getCode(cause);
        }
        if (code != null) {
            exceptionDto.setCode(code);
        }
    }

    protected Integer getCode(Throwable throwable) {
        ProcessEngineException pex = (ProcessEngineException)throwable;
        return pex.getCode();
    }

    public ExceptionDto fromException(Throwable e) {
        if (e instanceof MigratingProcessInstanceValidationException) {
            return MigratingProcessInstanceValidationExceptionDto.from((MigratingProcessInstanceValidationException)e);
        }
        if (e instanceof MigrationPlanValidationException) {
            return MigrationPlanValidationExceptionDto.from((MigrationPlanValidationException)e);
        }
        if (e instanceof AuthorizationException) {
            return AuthorizationExceptionDto.fromException((AuthorizationException)e);
        }
        if (e instanceof ParseException) {
            return ParseExceptionDto.fromException((ParseException)e);
        }
        return ExceptionDto.fromException(e);
    }

    public Response.Status getStatus(Throwable exception) {
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof ProcessEngineException) {
            responseStatus = this.getStatus((ProcessEngineException)exception);
        } else if (exception instanceof RestException) {
            responseStatus = this.getStatus((RestException)exception);
        } else if (exception instanceof WebApplicationException) {
            int statusCode = ((WebApplicationException)exception).getResponse().getStatus();
            responseStatus = Response.Status.fromStatusCode((int)statusCode);
        }
        return responseStatus;
    }

    public Response.Status getStatus(ProcessEngineException exception) {
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof AuthorizationException) {
            responseStatus = Response.Status.FORBIDDEN;
        } else if (exception instanceof MigrationPlanValidationException || exception instanceof MigratingProcessInstanceValidationException || exception instanceof BadUserRequestException || exception instanceof ParseException) {
            responseStatus = Response.Status.BAD_REQUEST;
        }
        return responseStatus;
    }

    public Response.Status getStatus(RestException exception) {
        if (exception.getStatus() != null) {
            return exception.getStatus();
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

