/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.SignalRestService;
import org.camunda.bpm.engine.rest.dto.SignalDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.runtime.SignalEventReceivedBuilder;
import org.camunda.bpm.engine.variable.VariableMap;

public class SignalRestServiceImpl
extends AbstractRestProcessEngineAware
implements SignalRestService {
    public SignalRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void throwSignal(SignalDto dto) {
        String name = dto.getName();
        if (name == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No signal name given");
        }
        SignalEventReceivedBuilder signalEvent = this.createSignalEventReceivedBuilder(dto);
        signalEvent.send();
    }

    protected SignalEventReceivedBuilder createSignalEventReceivedBuilder(SignalDto dto) {
        boolean isWithoutTenantId;
        String tenantId;
        Map<String, VariableValueDto> variablesDto;
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        String name = dto.getName();
        SignalEventReceivedBuilder signalEvent = runtimeService.createSignalEvent(name);
        String executionId = dto.getExecutionId();
        if (executionId != null) {
            signalEvent.executionId(executionId);
        }
        if ((variablesDto = dto.getVariables()) != null) {
            VariableMap variables = VariableValueDto.toMap(variablesDto, this.processEngine, this.objectMapper);
            signalEvent.setVariables((Map)variables);
        }
        if ((tenantId = dto.getTenantId()) != null) {
            signalEvent.tenantId(tenantId);
        }
        if (isWithoutTenantId = dto.isWithoutTenantId()) {
            signalEvent.withoutTenantId();
        }
        return signalEvent;
    }
}

