/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricTaskInstanceQueryDto
extends AbstractQueryDto<HistoricTaskInstanceQuery> {
    private static final String SORT_BY_TASK_ID = "taskId";
    private static final String SORT_BY_ACT_INSTANCE_ID = "activityInstanceId";
    private static final String SORT_BY_PROC_DEF_ID = "processDefinitionId";
    private static final String SORT_BY_PROC_INST_ID = "processInstanceId";
    private static final String SORT_BY_EXEC_ID = "executionId";
    private static final String SORT_BY_CASE_DEF_ID = "caseDefinitionId";
    private static final String SORT_BY_CASE_INST_ID = "caseInstanceId";
    private static final String SORT_BY_CASE_EXEC_ID = "caseExecutionId";
    private static final String SORT_BY_TASK_DURATION = "duration";
    private static final String SORT_BY_END_TIME = "endTime";
    private static final String SORT_BY_START_TIME = "startTime";
    private static final String SORT_BY_TASK_NAME = "taskName";
    private static final String SORT_BY_TASK_DESC = "taskDescription";
    private static final String SORT_BY_ASSIGNEE = "assignee";
    private static final String SORT_BY_OWNER = "owner";
    private static final String SORT_BY_DUE_DATE = "dueDate";
    private static final String SORT_BY_FOLLOW_UP_DATE = "followUpDate";
    private static final String SORT_BY_DELETE_REASON = "deleteReason";
    private static final String SORT_BY_TASK_DEF_KEY = "taskDefinitionKey";
    private static final String SORT_BY_PRIORITY = "priority";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String taskId;
    protected String taskParentTaskId;
    protected String processInstanceId;
    protected String rootProcessInstanceId;
    protected String processInstanceBusinessKey;
    protected String[] processInstanceBusinessKeyIn;
    protected String processInstanceBusinessKeyLike;
    protected String executionId;
    protected String[] activityInstanceIdIn;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected String taskName;
    protected String taskNameLike;
    protected String taskDescription;
    protected String taskDescriptionLike;
    protected String taskDefinitionKey;
    protected String[] taskDefinitionKeyIn;
    protected String taskDeleteReason;
    protected String taskDeleteReasonLike;
    protected Boolean assigned;
    protected Boolean unassigned;
    protected String taskAssignee;
    protected String taskAssigneeLike;
    protected String taskOwner;
    protected String taskOwnerLike;
    protected Integer taskPriority;
    protected Boolean finished;
    protected Boolean unfinished;
    protected Boolean processFinished;
    protected Boolean processUnfinished;
    protected Date taskDueDate;
    protected Date taskDueDateBefore;
    protected Date taskDueDateAfter;
    protected Boolean withoutTaskDueDate;
    protected Date taskFollowUpDate;
    protected Date taskFollowUpDateBefore;
    protected Date taskFollowUpDateAfter;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String caseDefinitionName;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String taskInvolvedUser;
    protected String taskInvolvedGroup;
    protected String taskHadCandidateUser;
    protected String taskHadCandidateGroup;
    protected Boolean withCandidateGroups;
    protected Boolean withoutCandidateGroups;
    protected List<VariableQueryParameterDto> taskVariables;
    protected List<VariableQueryParameterDto> processVariables;
    protected Boolean variableValuesIgnoreCase;
    protected Boolean variableNamesIgnoreCase;
    private List<HistoricTaskInstanceQueryDto> orQueries;

    public HistoricTaskInstanceQueryDto() {
    }

    public HistoricTaskInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="orQueries")
    public void setOrQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    @CamundaQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @CamundaQueryParam(value="taskParentTaskId")
    public void setTaskParentTaskId(String taskParentTaskId) {
        this.taskParentTaskId = taskParentTaskId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="rootProcessInstanceId")
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    @CamundaQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String businessKey) {
        this.processInstanceBusinessKey = businessKey;
    }

    @CamundaQueryParam(value="processInstanceBusinessKeyIn", converter=StringArrayConverter.class)
    public void setProcessInstanceBusinessKeyIn(String[] processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    @CamundaQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String businessKeyLike) {
        this.processInstanceBusinessKeyLike = businessKeyLike;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @CamundaQueryParam(value="taskName")
    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @CamundaQueryParam(value="taskNameLike")
    public void setTaskNameLike(String taskNameLike) {
        this.taskNameLike = taskNameLike;
    }

    @CamundaQueryParam(value="taskDescription")
    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    @CamundaQueryParam(value="taskDescriptionLike")
    public void setTaskDescriptionLike(String taskDescriptionLike) {
        this.taskDescriptionLike = taskDescriptionLike;
    }

    @CamundaQueryParam(value="taskDefinitionKey")
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @CamundaQueryParam(value="taskDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setTaskDefinitionKeyIn(String[] taskDefinitionKeyIn) {
        this.taskDefinitionKeyIn = taskDefinitionKeyIn;
    }

    @CamundaQueryParam(value="taskDeleteReason")
    public void setTaskDeleteReason(String taskDeleteReason) {
        this.taskDeleteReason = taskDeleteReason;
    }

    @CamundaQueryParam(value="taskDeleteReasonLike")
    public void setTaskDeleteReasonLike(String taskDeleteReasonLike) {
        this.taskDeleteReasonLike = taskDeleteReasonLike;
    }

    @CamundaQueryParam(value="assigned", converter=BooleanConverter.class)
    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    @CamundaQueryParam(value="unassigned", converter=BooleanConverter.class)
    public void setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
    }

    @CamundaQueryParam(value="taskAssignee")
    public void setTaskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
    }

    @CamundaQueryParam(value="taskAssigneeLike")
    public void setTaskAssigneeLike(String taskAssigneeLike) {
        this.taskAssigneeLike = taskAssigneeLike;
    }

    @CamundaQueryParam(value="taskOwner")
    public void setTaskOwner(String taskOwner) {
        this.taskOwner = taskOwner;
    }

    @CamundaQueryParam(value="taskOwnerLike")
    public void setTaskOwnerLike(String taskOwnerLike) {
        this.taskOwnerLike = taskOwnerLike;
    }

    @CamundaQueryParam(value="taskPriority", converter=IntegerConverter.class)
    public void setTaskPriority(Integer taskPriority) {
        this.taskPriority = taskPriority;
    }

    @CamundaQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @CamundaQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @CamundaQueryParam(value="processFinished", converter=BooleanConverter.class)
    public void setProcessFinished(Boolean processFinished) {
        this.processFinished = processFinished;
    }

    @CamundaQueryParam(value="processUnfinished", converter=BooleanConverter.class)
    public void setProcessUnfinished(Boolean processUnfinished) {
        this.processUnfinished = processUnfinished;
    }

    @CamundaQueryParam(value="taskDueDate", converter=DateConverter.class)
    public void setTaskDueDate(Date taskDueDate) {
        this.taskDueDate = taskDueDate;
    }

    @CamundaQueryParam(value="taskDueDateBefore", converter=DateConverter.class)
    public void setTaskDueDateBefore(Date taskDueDateBefore) {
        this.taskDueDateBefore = taskDueDateBefore;
    }

    @CamundaQueryParam(value="taskDueDateAfter", converter=DateConverter.class)
    public void setTaskDueDateAfter(Date taskDueDateAfter) {
        this.taskDueDateAfter = taskDueDateAfter;
    }

    @CamundaQueryParam(value="withoutTaskDueDate", converter=BooleanConverter.class)
    public void setWithoutTaskDueDate(Boolean withoutTaskDueDate) {
        this.withoutTaskDueDate = withoutTaskDueDate;
    }

    @CamundaQueryParam(value="taskFollowUpDate", converter=DateConverter.class)
    public void setTaskFollowUpDate(Date taskFollowUpDate) {
        this.taskFollowUpDate = taskFollowUpDate;
    }

    @CamundaQueryParam(value="taskFollowUpDateBefore", converter=DateConverter.class)
    public void setTaskFollowUpDateBefore(Date taskFollowUpDateBefore) {
        this.taskFollowUpDateBefore = taskFollowUpDateBefore;
    }

    @CamundaQueryParam(value="taskFollowUpDateAfter", converter=DateConverter.class)
    public void setTaskFollowUpDateAfter(Date taskFollowUpDateAfter) {
        this.taskFollowUpDateAfter = taskFollowUpDateAfter;
    }

    @CamundaQueryParam(value="taskVariables", converter=VariableListConverter.class)
    public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
    }

    @CamundaQueryParam(value="processVariables", converter=VariableListConverter.class)
    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    @CamundaQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @CamundaQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @CamundaQueryParam(value="caseDefinitionName")
    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="taskInvolvedUser")
    public void setTaskInvolvedUser(String taskInvolvedUser) {
        this.taskInvolvedUser = taskInvolvedUser;
    }

    @CamundaQueryParam(value="taskInvolvedGroup")
    public void setTaskInvolvedGroup(String taskInvolvedGroup) {
        this.taskInvolvedGroup = taskInvolvedGroup;
    }

    @CamundaQueryParam(value="taskHadCandidateUser")
    public void setTaskHadCandidateUser(String taskHadCandidateUser) {
        this.taskHadCandidateUser = taskHadCandidateUser;
    }

    @CamundaQueryParam(value="taskHadCandidateGroup")
    public void setTaskHadCandidateGroup(String taskHadCandidateGroup) {
        this.taskHadCandidateGroup = taskHadCandidateGroup;
    }

    @CamundaQueryParam(value="withCandidateGroups", converter=BooleanConverter.class)
    public void setWithCandidateGroups(Boolean withCandidateGroups) {
        this.withCandidateGroups = withCandidateGroups;
    }

    @CamundaQueryParam(value="withoutCandidateGroups", converter=BooleanConverter.class)
    public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
        this.withoutCandidateGroups = withoutCandidateGroups;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @CamundaQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @CamundaQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricTaskInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricTaskInstanceQuery();
    }

    public List<HistoricTaskInstanceQueryDto> getOrQueries() {
        return this.orQueries;
    }

    @Override
    protected void applyFilters(HistoricTaskInstanceQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.orQueries != null) {
            for (HistoricTaskInstanceQueryDto orQueryDto : this.orQueries) {
                HistoricTaskInstanceQueryImpl orQuery = new HistoricTaskInstanceQueryImpl();
                orQuery.setOrQueryActive();
                orQueryDto.applyFilters((HistoricTaskInstanceQuery)orQuery);
                ((HistoricTaskInstanceQueryImpl)query).addOrQuery(orQuery);
            }
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.taskParentTaskId != null) {
            query.taskParentTaskId(this.taskParentTaskId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.rootProcessInstanceId != null) {
            query.rootProcessInstanceId(this.rootProcessInstanceId);
        }
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyIn != null && this.processInstanceBusinessKeyIn.length > 0) {
            query.processInstanceBusinessKeyIn(this.processInstanceBusinessKeyIn);
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.taskName != null) {
            query.taskName(this.taskName);
        }
        if (this.taskNameLike != null) {
            query.taskNameLike(this.taskNameLike);
        }
        if (this.taskDescription != null) {
            query.taskDescription(this.taskDescription);
        }
        if (this.taskDescriptionLike != null) {
            query.taskDescriptionLike(this.taskDescriptionLike);
        }
        if (this.taskDefinitionKey != null) {
            query.taskDefinitionKey(this.taskDefinitionKey);
        }
        if (this.taskDefinitionKeyIn != null && this.taskDefinitionKeyIn.length > 0) {
            query.taskDefinitionKeyIn(this.taskDefinitionKeyIn);
        }
        if (this.taskDeleteReason != null) {
            query.taskDeleteReason(this.taskDeleteReason);
        }
        if (this.taskDeleteReasonLike != null) {
            query.taskDeleteReasonLike(this.taskDeleteReasonLike);
        }
        if (this.assigned != null) {
            query.taskAssigned();
        }
        if (this.unassigned != null) {
            query.taskUnassigned();
        }
        if (this.taskAssignee != null) {
            query.taskAssignee(this.taskAssignee);
        }
        if (this.taskAssigneeLike != null) {
            query.taskAssigneeLike(this.taskAssigneeLike);
        }
        if (this.taskOwner != null) {
            query.taskOwner(this.taskOwner);
        }
        if (this.taskOwnerLike != null) {
            query.taskOwnerLike(this.taskOwnerLike);
        }
        if (this.taskPriority != null) {
            query.taskPriority(this.taskPriority);
        }
        if (this.finished != null) {
            query.finished();
        }
        if (this.unfinished != null) {
            query.unfinished();
        }
        if (this.processFinished != null) {
            query.processFinished();
        }
        if (this.processUnfinished != null) {
            query.processUnfinished();
        }
        if (this.taskDueDate != null) {
            query.taskDueDate(this.taskDueDate);
        }
        if (this.taskDueDateBefore != null) {
            query.taskDueBefore(this.taskDueDateBefore);
        }
        if (this.taskDueDateAfter != null) {
            query.taskDueAfter(this.taskDueDateAfter);
        }
        if (Boolean.TRUE.equals(this.withoutTaskDueDate)) {
            query.withoutTaskDueDate();
        }
        if (this.taskFollowUpDate != null) {
            query.taskFollowUpDate(this.taskFollowUpDate);
        }
        if (this.taskFollowUpDateBefore != null) {
            query.taskFollowUpBefore(this.taskFollowUpDateBefore);
        }
        if (this.taskFollowUpDateAfter != null) {
            query.taskFollowUpAfter(this.taskFollowUpDateAfter);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionName != null) {
            query.caseDefinitionName(this.caseDefinitionName);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.taskInvolvedUser != null) {
            query.taskInvolvedUser(this.taskInvolvedUser);
        }
        if (this.taskInvolvedGroup != null) {
            query.taskInvolvedGroup(this.taskInvolvedGroup);
        }
        if (this.taskHadCandidateUser != null) {
            query.taskHadCandidateUser(this.taskHadCandidateUser);
        }
        if (this.taskHadCandidateGroup != null) {
            query.taskHadCandidateGroup(this.taskHadCandidateGroup);
        }
        if (this.withCandidateGroups != null) {
            query.withCandidateGroups();
        }
        if (this.withoutCandidateGroups != null) {
            query.withoutCandidateGroups();
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.taskVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.taskVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.taskVariableValueEquals(variableName, variableValue);
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.processVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.processVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.processVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.processVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.processVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.processVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.processVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.processVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.processVariableValueLike(variableName, (Object)String.valueOf(variableValue));
                    continue;
                }
                if (op.equals("notLike")) {
                    query.processVariableValueNotLike(variableName, (Object)String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid process variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(HistoricTaskInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TASK_ID)) {
            query.orderByTaskId();
        } else if (sortBy.equals(SORT_BY_ACT_INSTANCE_ID)) {
            query.orderByHistoricActivityInstanceId();
        } else if (sortBy.equals(SORT_BY_PROC_DEF_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROC_INST_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_EXEC_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_TASK_DURATION)) {
            query.orderByHistoricTaskInstanceDuration();
        } else if (sortBy.equals(SORT_BY_END_TIME)) {
            query.orderByHistoricTaskInstanceEndTime();
        } else if (sortBy.equals(SORT_BY_START_TIME)) {
            query.orderByHistoricActivityInstanceStartTime();
        } else if (sortBy.equals(SORT_BY_TASK_NAME)) {
            query.orderByTaskName();
        } else if (sortBy.equals(SORT_BY_TASK_DESC)) {
            query.orderByTaskDescription();
        } else if (sortBy.equals(SORT_BY_ASSIGNEE)) {
            query.orderByTaskAssignee();
        } else if (sortBy.equals(SORT_BY_OWNER)) {
            query.orderByTaskOwner();
        } else if (sortBy.equals(SORT_BY_DUE_DATE)) {
            query.orderByTaskDueDate();
        } else if (sortBy.equals(SORT_BY_FOLLOW_UP_DATE)) {
            query.orderByTaskFollowUpDate();
        } else if (sortBy.equals(SORT_BY_DELETE_REASON)) {
            query.orderByDeleteReason();
        } else if (sortBy.equals(SORT_BY_TASK_DEF_KEY)) {
            query.orderByTaskDefinitionKey();
        } else if (sortBy.equals(SORT_BY_PRIORITY)) {
            query.orderByTaskPriority();
        } else if (sortBy.equals(SORT_BY_CASE_DEF_ID)) {
            query.orderByCaseDefinitionId();
        } else if (sortBy.equals(SORT_BY_CASE_INST_ID)) {
            query.orderByCaseInstanceId();
        } else if (sortBy.equals(SORT_BY_CASE_EXEC_ID)) {
            query.orderByCaseExecutionId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACT_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROC_DEF_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROC_INST_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXEC_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_DEF_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INST_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_EXEC_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_DURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_DURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_END_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_START_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_NAME);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_DESC);
        VALID_SORT_BY_VALUES.add(SORT_BY_ASSIGNEE);
        VALID_SORT_BY_VALUES.add(SORT_BY_OWNER);
        VALID_SORT_BY_VALUES.add(SORT_BY_DUE_DATE);
        VALID_SORT_BY_VALUES.add(SORT_BY_FOLLOW_UP_DATE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DELETE_REASON);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_DEF_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_PRIORITY);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

