/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.lang.reflect.UndeclaredThrowableException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;

public class JtaTransactionInterceptor
extends CommandInterceptor {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final TransactionManager transactionManager;
    protected final boolean requiresNew;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public JtaTransactionInterceptor(TransactionManager transactionManager, boolean requiresNew, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.transactionManager = transactionManager;
        this.requiresNew = requiresNew;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        T t;
        Transaction oldTx = null;
        try {
            T result;
            boolean isNew;
            boolean existing = this.isExisting();
            boolean bl = isNew = !existing || this.requiresNew;
            if (existing && this.requiresNew) {
                oldTx = this.doSuspend();
            }
            if (isNew) {
                this.doBegin();
            }
            try {
                result = this.next.execute(command);
            }
            catch (RuntimeException ex) {
                this.doRollback(isNew);
                throw ex;
            }
            catch (Error err) {
                this.doRollback(isNew);
                throw err;
            }
            catch (Exception ex) {
                this.doRollback(isNew);
                throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
            }
            if (isNew) {
                this.doCommit();
            }
            t = result;
            this.doResume(oldTx);
        }
        catch (Throwable throwable) {
            this.doResume(oldTx);
            throw throwable;
        }
        return t;
    }

    private void doBegin() {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
    }

    private boolean isExisting() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to retrieve transaction status", e);
        }
    }

    private Transaction doSuspend() {
        try {
            return this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to suspend transaction", e);
        }
    }

    private void doResume(Transaction tx) {
        if (tx != null) {
            try {
                this.transactionManager.resume(tx);
            }
            catch (SystemException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
            catch (InvalidTransactionException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
        }
    }

    private void doCommit() {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (RollbackException e) {
            if (DbSqlSession.isCrdbConcurrencyConflictOnCommit(e, this.processEngineConfiguration)) {
                throw ProcessEngineLogger.PERSISTENCE_LOGGER.crdbTransactionRetryExceptionOnCommit(e);
            }
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (RuntimeException e) {
            this.doRollback(true);
            throw e;
        }
        catch (Error e) {
            this.doRollback(true);
            throw e;
        }
    }

    private void doRollback(boolean isNew) {
        try {
            if (isNew) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            LOG.exceptionWhileRollingBackTransaction((Exception)((Object)e));
        }
    }

    public static class TransactionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TransactionException() {
        }

        private TransactionException(String s) {
            super(s);
        }

        private TransactionException(String s, Throwable throwable) {
            super(s, throwable);
        }

        private TransactionException(Throwable throwable) {
            super(throwable);
        }
    }
}

