/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.Callback;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.AbstractPvmEventAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationProcessStart
extends AbstractPvmEventAtomicOperation {
    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return execution.getActivity().isAsyncBefore();
    }

    @Override
    public boolean isAsyncCapable() {
        return true;
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.getProcessInstanceStartContext();
        if (execution.getActivity() != null && execution.getActivity().isAsyncBefore()) {
            LegacyBehavior.createMissingHistoricVariables(execution);
        }
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        execution.continueIfExecutionDoesNotAffectNextOperation(new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                execution.dispatchEvent(null);
                return null;
            }
        }, new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                ProcessInstanceStartContext processInstanceStartContext = execution.getProcessInstanceStartContext();
                InstantiationStack instantiationStack = processInstanceStartContext.getInstantiationStack();
                if (instantiationStack.getActivities().isEmpty()) {
                    execution.setActivity(instantiationStack.getTargetActivity());
                    execution.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
                } else {
                    execution.setActivityInstanceId(execution.getId());
                    execution.performOperation(PvmAtomicOperation.ACTIVITY_INIT_STACK);
                }
                return null;
            }
        }, execution);
    }

    @Override
    public String getCanonicalName() {
        return "process-start";
    }
}

