/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;


/**
 * Represents a BPMN Error definition, whereas {@link BpmnError} represents an
 * actual instance of an Error.
 * 
 * @author Joram Barrez
 */
public class Error {
  
  protected String id;
  protected String errorCode;
  private ParameterValueProvider errorMessageExpression;

  public String getId() {
    return id;
  }
  
  public void setId(String id) {
    this.id = id;
  }
  
  public String getErrorCode() {
    return errorCode;
  }
  
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  public ParameterValueProvider getErrorMessageExpression() {
    return errorMessageExpression;
  }

  public void setErrorMessageExpression(ParameterValueProvider errorMessageExpression) {
    this.errorMessageExpression = errorMessageExpression;
  }
}
