/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instance;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.migration.MigratingActivityInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigratingTransitionInstanceValidationReport;

public class MigratingProcessInstanceValidationReportImpl
implements MigratingProcessInstanceValidationReport {
    protected String processInstanceId;
    protected List<MigratingActivityInstanceValidationReport> activityInstanceReports = new ArrayList<MigratingActivityInstanceValidationReport>();
    protected List<MigratingTransitionInstanceValidationReport> transitionInstanceReports = new ArrayList<MigratingTransitionInstanceValidationReport>();
    protected List<String> failures = new ArrayList<String>();

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void addActivityInstanceReport(MigratingActivityInstanceValidationReport instanceReport) {
        this.activityInstanceReports.add(instanceReport);
    }

    public void addTransitionInstanceReport(MigratingTransitionInstanceValidationReport instanceReport) {
        this.transitionInstanceReports.add(instanceReport);
    }

    @Override
    public List<MigratingActivityInstanceValidationReport> getActivityInstanceReports() {
        return this.activityInstanceReports;
    }

    @Override
    public List<MigratingTransitionInstanceValidationReport> getTransitionInstanceReports() {
        return this.transitionInstanceReports;
    }

    public void addFailure(String failure) {
        this.failures.add(failure);
    }

    @Override
    public List<String> getFailures() {
        return this.failures;
    }

    @Override
    public boolean hasFailures() {
        return !this.failures.isEmpty() || !this.activityInstanceReports.isEmpty() || !this.transitionInstanceReports.isEmpty();
    }

    public void writeTo(StringBuilder sb) {
        sb.append("Cannot migrate process instance '").append(this.processInstanceId).append("':\n");
        for (String string : this.failures) {
            sb.append("\t").append(string).append("\n");
        }
        for (MigratingActivityInstanceValidationReport migratingActivityInstanceValidationReport : this.activityInstanceReports) {
            sb.append("\tCannot migrate activity instance '").append(migratingActivityInstanceValidationReport.getActivityInstanceId()).append("':\n");
            for (String failure : migratingActivityInstanceValidationReport.getFailures()) {
                sb.append("\t\t").append(failure).append("\n");
            }
        }
        for (MigratingTransitionInstanceValidationReport migratingTransitionInstanceValidationReport : this.transitionInstanceReports) {
            sb.append("\tCannot migrate transition instance '").append(migratingTransitionInstanceValidationReport.getTransitionInstanceId()).append("':\n");
            for (String failure : migratingTransitionInstanceValidationReport.getFailures()) {
                sb.append("\t\t").append(failure).append("\n");
            }
        }
    }
}

