/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public abstract class ExecutableScript {
    protected final String language;

    protected ExecutableScript(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public Object execute(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        return this.evaluate(scriptEngine, variableScope, bindings);
    }

    protected String getActivityIdExceptionMessage(VariableScope variableScope) {
        String activityId = null;
        Object definitionIdMessage = "";
        if (variableScope instanceof DelegateExecution) {
            activityId = ((DelegateExecution)variableScope).getCurrentActivityId();
            definitionIdMessage = " in the process definition with id '" + ((DelegateExecution)variableScope).getProcessDefinitionId() + "'";
        } else if (variableScope instanceof TaskEntity) {
            TaskEntity task = (TaskEntity)variableScope;
            if (task.getExecution() != null) {
                activityId = task.getExecution().getActivityId();
                definitionIdMessage = " in the process definition with id '" + task.getProcessDefinitionId() + "'";
            }
            if (task.getCaseExecution() != null) {
                activityId = task.getCaseExecution().getActivityId();
                definitionIdMessage = " in the case definition with id '" + task.getCaseDefinitionId() + "'";
            }
        } else if (variableScope instanceof DelegateCaseExecution) {
            activityId = ((DelegateCaseExecution)variableScope).getActivityId();
            definitionIdMessage = " in the case definition with id '" + ((DelegateCaseExecution)variableScope).getCaseDefinitionId() + "'";
        }
        if (activityId == null) {
            return "";
        }
        return " while executing activity '" + activityId + "'" + (String)definitionIdMessage;
    }

    protected abstract Object evaluate(ScriptEngine var1, VariableScope var2, Bindings var3);
}

