/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.AbstractGetDeployedFormCmd;
import org.camunda.bpm.engine.impl.cmd.GetTaskFormCmd;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetDeployedTaskFormCmd
extends AbstractGetDeployedFormCmd {
    protected String taskId;

    public GetDeployedTaskFormCmd(String taskId) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Task id cannot be null", "taskId", (Object)taskId);
        this.taskId = taskId;
    }

    @Override
    protected FormData getFormData() {
        return this.commandContext.runWithoutAuthorization(new GetTaskFormCmd(this.taskId));
    }

    @Override
    protected void checkAuthorization() {
        TaskEntity taskEntity = this.commandContext.getTaskManager().findTaskById(this.taskId);
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTask(taskEntity);
        }
    }
}

