/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.helper;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorDeclarationForProcessInstanceFinder;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagationException;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionHierarchyWalker;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionMappingCollector;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionTuple;
import org.camunda.bpm.engine.impl.tree.OutputVariablesPropagator;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;

public class BpmnExceptionHandler {
    private static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    public static void propagateException(ActivityExecution execution, Exception ex) throws Exception {
        BpmnError bpmnError = BpmnExceptionHandler.checkIfCauseOfExceptionIsBpmnError(ex);
        if (bpmnError != null) {
            BpmnExceptionHandler.propagateBpmnError(bpmnError, execution);
        } else {
            BpmnExceptionHandler.propagateExceptionAsError(ex, execution);
        }
    }

    protected static void propagateExceptionAsError(Exception exception, ActivityExecution execution) throws Exception {
        if (BpmnExceptionHandler.isProcessEngineExceptionWithoutCause(exception) || BpmnExceptionHandler.isTransactionNotActive()) {
            throw exception;
        }
        BpmnExceptionHandler.propagateError(null, exception.getMessage(), exception, execution);
    }

    protected static boolean isTransactionNotActive() {
        return !Context.getCommandContext().getTransactionContext().isTransactionActive();
    }

    protected static boolean isProcessEngineExceptionWithoutCause(Exception exception) {
        return exception instanceof ProcessEngineException && exception.getCause() == null;
    }

    protected static BpmnError checkIfCauseOfExceptionIsBpmnError(Throwable e) {
        if (e instanceof BpmnError) {
            return (BpmnError)e;
        }
        if (e.getCause() == null) {
            return null;
        }
        return BpmnExceptionHandler.checkIfCauseOfExceptionIsBpmnError(e.getCause());
    }

    public static void propagateBpmnError(BpmnError error, ActivityExecution execution) throws Exception {
        BpmnExceptionHandler.propagateError(error.getErrorCode(), error.getMessage(), null, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void propagateError(String errorCode, String errorMessage, Exception origException, ActivityExecution execution) throws Exception {
        ActivityExecutionHierarchyWalker walker = new ActivityExecutionHierarchyWalker(execution);
        final ErrorDeclarationForProcessInstanceFinder errorDeclarationFinder = new ErrorDeclarationForProcessInstanceFinder(origException, errorCode, execution.getActivity());
        ActivityExecutionMappingCollector activityExecutionMappingCollector = new ActivityExecutionMappingCollector(execution);
        walker.addScopePreVisitor(errorDeclarationFinder);
        walker.addExecutionPreVisitor(activityExecutionMappingCollector);
        walker.addExecutionPreVisitor(new OutputVariablesPropagator());
        try {
            walker.walkUntil(new ReferenceWalker.WalkCondition<ActivityExecutionTuple>(){

                @Override
                public boolean isFulfilled(ActivityExecutionTuple element) {
                    return errorDeclarationFinder.getErrorEventDefinition() != null || element == null;
                }
            });
        }
        catch (Exception e) {
            LOG.errorPropagationException(execution.getActivityInstanceId(), e);
            throw new ErrorPropagationException(e.getCause());
        }
        PvmActivity errorHandlingActivity = errorDeclarationFinder.getErrorHandlerActivity();
        if (errorHandlingActivity == null) {
            if (origException != null) throw origException;
            if (Context.getCommandContext().getProcessEngineConfiguration().isEnableExceptionsAfterUnhandledBpmnError()) {
                throw LOG.missingBoundaryCatchEventError(execution.getActivity().getId(), errorCode);
            }
            LOG.missingBoundaryCatchEvent(execution.getActivity().getId(), errorCode);
            execution.end(true);
            return;
        } else {
            ErrorEventDefinition errorDefinition = errorDeclarationFinder.getErrorEventDefinition();
            PvmExecutionImpl errorHandlingExecution = activityExecutionMappingCollector.getExecutionForScope(errorHandlingActivity.getEventScope());
            if (errorDefinition.getErrorCodeVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorCodeVariable(), errorCode);
            }
            if (errorDefinition.getErrorMessageVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorMessageVariable(), errorMessage);
            }
            errorHandlingExecution.executeActivity(errorHandlingActivity);
        }
    }
}

