/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.HandleExternalTaskCmd;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HandleExternalTaskBpmnErrorCmd
extends HandleExternalTaskCmd {
    protected String errorCode;

    public HandleExternalTaskBpmnErrorCmd(String externalTaskId, String workerId, String errorCode) {
        super(externalTaskId, workerId);
        this.errorCode = errorCode;
    }

    @Override
    protected void validateInput() {
        super.validateInput();
        EnsureUtil.ensureNotNull("errorCode", (Object)this.errorCode);
    }

    @Override
    public String getErrorMessageOnWrongWorkerAccess() {
        return "Bpmn error of External Task " + this.externalTaskId + " cannot be reported by worker '" + this.workerId;
    }

    @Override
    public void execute(ExternalTaskEntity externalTask) {
        externalTask.bpmnError(this.errorCode);
    }
}

