/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.deployer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.engine.impl.AbstractDefinitionDeployer;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.core.model.Properties;
import org.camunda.bpm.engine.impl.dmn.DecisionLogger;
import org.camunda.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class DecisionRequirementsDefinitionDeployer
extends AbstractDefinitionDeployer<DecisionRequirementsDefinitionEntity> {
    protected static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;
    protected DmnTransformer transformer;

    @Override
    protected String[] getResourcesSuffixes() {
        return DecisionDefinitionDeployer.DMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<DecisionRequirementsDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        byte[] bytes = resource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            DecisionRequirementsDefinitionEntity drd = (DecisionRequirementsDefinitionEntity)this.transformer.createTransform().modelInstance((InputStream)inputStream).transformDecisionRequirementsGraph();
            return Collections.singletonList(drd);
        }
        catch (Exception e) {
            throw LOG.exceptionParseDmnResource(resource.getName(), e);
        }
    }

    @Override
    protected DecisionRequirementsDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getDecisionDefinitionManager().findDecisionRequirementsDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected DecisionRequirementsDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getDecisionDefinitionManager().findLatestDecisionRequirementsDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(DecisionRequirementsDefinitionEntity definition) {
        if (DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(definition)) {
            this.getDecisionDefinitionManager().insertDecisionRequirementsDefinition(definition);
        }
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, DecisionRequirementsDefinitionEntity definition) {
        if (DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(definition)) {
            deploymentCache.addDecisionRequirementsDefinition(definition);
        }
    }

    @Override
    protected void ensureNoDuplicateDefinitionKeys(List<DecisionRequirementsDefinitionEntity> definitions) {
        ArrayList<DecisionRequirementsDefinitionEntity> persistableDefinitions = new ArrayList<DecisionRequirementsDefinitionEntity>();
        for (DecisionRequirementsDefinitionEntity definition : definitions) {
            if (!DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(definition)) continue;
            persistableDefinitions.add(definition);
        }
        super.ensureNoDuplicateDefinitionKeys(persistableDefinitions);
    }

    public static boolean isDecisionRequirementsDefinitionPersistable(DecisionRequirementsDefinitionEntity definition) {
        return definition.getDecisions().size() > 1;
    }

    @Override
    protected void updateDefinitionByPersistedDefinition(DeploymentEntity deployment, DecisionRequirementsDefinitionEntity definition, DecisionRequirementsDefinitionEntity persistedDefinition) {
        if (persistedDefinition != null) {
            super.updateDefinitionByPersistedDefinition(deployment, definition, persistedDefinition);
        }
    }

    protected DecisionDefinitionManager getDecisionDefinitionManager() {
        return this.getCommandContext().getDecisionDefinitionManager();
    }

    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DmnTransformer transformer) {
        this.transformer = transformer;
    }
}

