/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricProcessInstancesBulkCmd
implements Command<Void>,
Serializable {
    protected final List<String> processInstanceIds;

    public DeleteHistoricProcessInstancesBulkCmd(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", this.processInstanceIds);
        commandContext.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EnsureUtil.ensureEquals(BadUserRequestException.class, "FinishedProcessInstanceIds", new HistoricProcessInstanceQueryImpl().finished().processInstanceIds(new HashSet<String>(DeleteHistoricProcessInstancesBulkCmd.this.processInstanceIds)).count(), DeleteHistoricProcessInstancesBulkCmd.this.processInstanceIds.size());
                return null;
            }
        });
        commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(this.processInstanceIds);
        return null;
    }
}

